﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品服务仓储层
    /// </summary>
    public class RB_Product_ServiceRepository : BaseRepository<RB_Product_Service>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Product_Service_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Product_Service_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Service.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Product_Service.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Product_Service.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Product_Service.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Product_Service.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsDefault > 0) {
                where += $@" and {nameof(RB_Product_Service.IsDefault)}={dmodel.IsDefault}";
            }

            string sql = $@"select * from RB_Product_Service where {where} order by Sort asc,Id desc";
            return GetPage<RB_Product_Service_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_Service_Extend> GetList(RB_Product_Service_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Service.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_Service.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_Service.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_Service.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.ServiceIds)) {
                where += $@" and {nameof(RB_Product_Service.Id)} in({dmodel.ServiceIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Product_Service.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsDefault > 0)
            {
                where += $@" and {nameof(RB_Product_Service.IsDefault)}={dmodel.IsDefault}";
            }

            string sql = $@"select * from RB_Product_Service where {where} order by Sort asc,Id desc";
            return Get<RB_Product_Service_Extend>(sql).ToList();
        }
    }
}
