﻿using VT.FW.DB;
using Mall.Common.Enum.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材盘点明细实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_CheckDetail
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点期数id
        /// </summary>        
        public int? CheckId
        {
            get;
            set;
        }
        /// <summary>
        /// 耗材id
        /// </summary>        
        public int? SuppliesId
        {
            get;
            set;
        }
        /// <summary>
        /// 当前库存的数量
        /// </summary>        
        public int? InventoryNum
        {
            get;
            set;
        }
        /// <summary>
        /// 实际数量
        /// </summary>        
        public int? RealityNum
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点状态
        /// </summary>        
        public SuppliesCheckStatusEnum? CheckStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点人
        /// </summary>        
        public int? CheckEmpId
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点时间
        /// </summary>        
        public DateTime? CheckDate
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点图片列表  json格式
        /// </summary>        
        public string Images
        {
            get;
            set;
        }
        /// <summary>
        /// 盘亏盘盈处理状态  1已处理  2未处理
        /// </summary>        
        public int? DealStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 备注(报损 /报溢 需备注记录  出库单号/入库单号)
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 报损/报溢  自动生成财务单据
        /// </summary>        
        public int? FinanceId
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0正常  1删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateBy
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
