﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品推荐设置表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Product_Recommend_Extend : RB_Product_Recommend
    {
        /// <summary>
        /// 订单完成后自定义推荐商品
        /// </summary>
        public List<RB_ProductRecommendModel> OrderProductList { get; set; }

        /// <summary>
        /// 评论后自定义推荐商品
        /// </summary>
        public List<RB_ProductRecommendModel> CommentProductList { get; set; }
    }

    /// <summary>
    /// 商品选择
    /// </summary>
    public class RB_ProductRecommendModel { 
        /// <summary>
        /// 商品id
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 商品图片
        /// </summary>
        public string Image { get; set; }
    }
}
