﻿using Mall.Common.Enum;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;
using System.Linq;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 分享处理类
    /// </summary>
    public class ShareModule
    {
        /// <summary>
        /// 分享分类仓储层对象
        /// </summary>
        private readonly RB_Share_CategoryRepository share_CategoryRepository = new RB_Share_CategoryRepository();

        /// <summary>
        /// 分享详情实体仓储层对象
        /// </summary>
        private readonly RB_Share_FriendRepository share_FriendRepository = new RB_Share_FriendRepository();

        /// <summary>
        /// 获取分享分类分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetShareCategoryPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Share_Category_Extend query)
        {
            return share_CategoryRepository.GetShareCategoryPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据上级编号获取所有子级分类
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetChildCategoryListModule(RB_Share_Category_Extend query)
        {
            return share_CategoryRepository.GetChildCategoryListRepository(query);
        }

        /// <summary>
        /// 获取分享分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<object> GetShareCategoryListModule(RB_Share_Category_Extend query)
        {
            List<object> resultList = new List<object>();
            var list = share_CategoryRepository.GetShareCategoryListRepository(query);
            if (list != null)
            {
                var leavelList = list.GroupBy(qitem => new { qitem.Level }).OrderBy(qitem => qitem.Key.Level);
                foreach (var item in list.Where(qitem => qitem.Level == 1).OrderBy(qitem => qitem.SortNum))
                {
                    List<object> secondList = new List<object>();
                    var subList = list.Where(qitem => qitem.Level == 2 && qitem.ParentId == item.Id).OrderBy(qitem => qitem.SortNum).ToList();
                    foreach (var subItem in subList)
                    {
                        var subModel = new
                        {
                            subItem.Id,
                            subItem.Level,
                            subItem.Name,
                            subItem.ParentId,
                            children = list.Where(qitem => qitem.Level == 3 && qitem.ParentId == subItem.Id).OrderBy(qitem => qitem.SortNum).Select(qitem => new { qitem.Id, qitem.Name, qitem.Level, qitem.ParentId })
                        };
                        secondList.Add(subModel);
                    }
                    var rootModel = new
                    {
                        item.Id,
                        item.Level,
                        item.Name,
                        item.ParentId,
                        children = secondList
                    };
                    resultList.Add(rootModel);
                }
            }
            return resultList;
        }

        /// <summary>
        /// 获取分享详情分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <param name="IsUse">true-只查询启用的</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Share_Friend_Extend query, bool IsUse = false)
        {
            var cateAllList = share_CategoryRepository.GetShareCategoryListRepository(new RB_Share_Category_Extend()
            {
                MallBaseId = query.MallBaseId,
                TenantId = query.TenantId
            });
            if (query.CateId > 0)
            {
                var cateList = GetChildCategoryListModule(new RB_Share_Category_Extend() { QCateIds = query.CateId.ToString() });
                query.CateId = 0;
                query.CateIds = string.Join(",", cateList.Select(qitem => qitem.Id));
            }
            var list = share_FriendRepository.GetShareFriendPageListRepository(pageIndex, pageSize, out rowsCount, query, IsUse: IsUse);
            foreach (var item in list)
            {
                item.CateList = GetFatherList(cateAllList, item.CateId).OrderBy(qitem => qitem.Level).ToList();
            }
            return list;
        }


        /// <summary>
        /// 获取所有上级分类
        /// </summary>
        /// <param name="list"></param>
        /// <param name="Id"></param>
        /// <returns></returns>
        public static IEnumerable<RB_Share_Category_Extend> GetFatherList(IList<RB_Share_Category_Extend> list, int Id)
        {
            var query = list.Where(p => p.Id == Id).ToList();
            return query.ToList().Concat(query.ToList().SelectMany(t => GetFatherList(list, t.ParentId)));
        }



        /// <summary>
        /// 获取分享详情列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Friend_Extend> GetShareFriendListModule(RB_Share_Friend_Extend query)
        {
            return share_FriendRepository.GetShareFriendListRepository(query);
        }

        /// <summary>
        /// 批量修改排序
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetShareCategorySortListModule(List<RB_Share_Category_Extend> list)
        {
            bool flag = false;
            foreach (var extModel in list)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Share_Category_Extend.SortNum),extModel.SortNum },
                };
                flag = share_CategoryRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Category_Extend.Id), extModel.Id));
            }
            return flag;
        }

        /// <summary>
        /// 新增修改分类
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetShareCategoryModule(RB_Share_Category_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Share_Category_Extend.Name),extModel.Name },
                    {nameof(RB_Share_Category_Extend.Level),extModel.Level },
                    {nameof(RB_Share_Category_Extend.ParentId),extModel.ParentId },
                    {nameof(RB_Share_Category_Extend.UpdateDate),extModel.UpdateDate },
                    {nameof(RB_Share_Category_Extend.SortNum),extModel.SortNum },
                };
                flag = share_CategoryRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Category_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = share_CategoryRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除分享分类
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveShareCategoryModule(object Id)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Category_Extend.Status),(int) DateStateEnum.Delete},
            };
            flag = share_CategoryRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Category_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 获取分享分类实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Share_Category_Extend GetShareCategoryModule(object Id)
        {
            var extModel = share_CategoryRepository.GetEntity<RB_Share_Category_Extend>(Id);
            if (extModel != null)
            {
                var cateAllList = share_CategoryRepository.GetShareCategoryListRepository(new RB_Share_Category_Extend()
                {
                    MallBaseId = extModel.MallBaseId,
                    TenantId = extModel.TenantId
                });
                var list= GetFatherList(cateAllList, extModel.Id).OrderBy(qitem => qitem.Level).ToList();
                extModel.FirstLevelName = list.Where(qitem=>qitem.Level==1)?.FirstOrDefault()?.Name??"";
                extModel.SecondLevelName = list.Where(qitem => qitem.Level == 2)?.FirstOrDefault()?.Name ?? "";
            }
            return extModel;
        }

        /// <summary>
        /// 新增修改分享详情
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetShareFriendModule(RB_Share_Friend_Extend extModel)
        {
            bool flag = false;
            flag = share_FriendRepository.SetShareFrendRepository(extModel);
            return flag;
        }

        /// <summary>
        /// 获取分享详情实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Share_Friend_Extend GetShareFriendModule(object Id)
        {
            var extModel = share_FriendRepository.GetShareFriendEntityRepository(new RB_Share_Friend_Extend() { Id = Convert.ToInt32(Id) });
            if (extModel != null)
            {
                var cateAllList = share_CategoryRepository.GetShareCategoryListRepository(new RB_Share_Category_Extend()
                {
                    MallBaseId = extModel.MallBaseId,
                    TenantId = extModel.TenantId
                });
                var list = GetFatherList(cateAllList, extModel.CateId).OrderBy(qitem => qitem.Level).ToList();
                extModel.FirstLevelName = list.Where(qitem => qitem.Level == 1)?.FirstOrDefault()?.Name ?? "";
                extModel.SecondLevelName = list.Where(qitem => qitem.Level == 2)?.FirstOrDefault()?.Name ?? "";
                extModel.ThirdLevelName = list.Where(qitem => qitem.Level == 3)?.FirstOrDefault()?.Name ?? "";
            }
            return extModel;
       }

        /// <summary>
        /// 根据编号删除分享详情
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveShareFriendModule(object Id)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.Status),(int) DateStateEnum.Delete},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新是否置顶
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="IsTop"></param>
        /// <returns></returns>
        public bool SetShareFriendIsTopModule(object Id, int IsTop)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.IsTop),IsTop},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新是否启用
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="IsUse"></param>
        /// <returns></returns>
        public bool SetShareFriendIsUseModule(object Id, int IsUse)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.IsUse),IsUse},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新排序
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="SortNum"></param>
        /// <returns></returns>
        public bool SetShareFriendSortNumModule(object Id, int SortNum)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.SortNum),SortNum},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新文案
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="MaterialInfo"></param>
        /// <returns></returns>
        public bool SetShareFriendMaterialInfoModule(object Id, string MaterialInfo)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Share_Friend_Extend.MaterialInfo),MaterialInfo},
            };
            flag = share_FriendRepository.Update(fileds, new WhereHelper(nameof(RB_Share_Friend_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新分享数量
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool SetShareFrendShareCountModule(object Id)
        {
            return share_FriendRepository.SetShareFrendShareCountRepository(Id);
        }
    }
}
