﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品分类仓储层
    /// </summary>
    public class RB_Product_CategoryRepository : BaseRepository<RB_Product_Category>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Product_Category_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Product_Category_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Category_Extend.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Product_Category_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Tier > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.Tier)}={dmodel.Tier}";
            }
            if (dmodel.ParentId > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.ParentId)}={dmodel.ParentId}";
            }
            if (dmodel.RootId > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.RootId)}={dmodel.RootId}";
            }
            if (dmodel.Enabled > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.Enabled)}={dmodel.Enabled}";
            }
            if (dmodel.IsShow > 0) {
                where += $@" and {nameof(RB_Product_Category_Extend.IsShow)}={dmodel.IsShow}";
            }

            string sql = $@"select * from RB_Product_Category where {where} order by Id asc";
            return GetPage<RB_Product_Category_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_Category_Extend> GetList(RB_Product_Category_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Product_Category_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds)) {
                where += $@" and {nameof(RB_Product_Category_Extend.Id)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Product_Category_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Tier > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.Tier)}={dmodel.Tier}";
            }
            if (dmodel.ParentId > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.ParentId)}={dmodel.ParentId}";
            }
            if (dmodel.RootId > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.RootId)}={dmodel.RootId}";
            }
            if (dmodel.Enabled > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.Enabled)}={dmodel.Enabled}";
            }
            if (dmodel.IsShow > 0)
            {
                where += $@" and {nameof(RB_Product_Category_Extend.IsShow)}={dmodel.IsShow}";
            }

            string sql = $@"select * from RB_Product_Category where {where} order by Id asc";
            return Get<RB_Product_Category_Extend>(sql).ToList();
        }

        /// <summary>
        /// 设置分类显示/隐藏
        /// </summary>
        /// <param name="isShow"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetProductCategoryShow(int isShow, int tenantId, int mallBaseId)
        {
            string sql;
            if (isShow == 1)
            {
                sql = $@"UPDATE rb_product_category  SET IsShow =2 WHERE TenantId ={tenantId} and MallBaseId={mallBaseId} and `Status`=0 AND Enabled =1 AND IsShow =1;";
            }
            else {
                sql = $@"UPDATE rb_product_category  SET IsShow =1 WHERE TenantId ={tenantId} and MallBaseId={mallBaseId} and `Status`=0 AND Enabled =1 AND IsShow =2;";
            }
            return Execute(sql) > 0;
        }
    }
}
