﻿using Mall.Common.Enum.GuideCar;
using Mall.Common.Enum.Reserve;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Reserve
{
    /// <summary>
    /// 服务人员实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Reserve_ServicePersonal
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

      
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 头像
        /// </summary>
        public string ServiceLogo { get; set; }

        public string LableName { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Major { get; set; }
        /// <summary>
        /// 状态1上架  2下架
        /// </summary>
        public int ServiceStatus { get; set; }

        /// <summary>
        /// 关联门店
        /// </summary>
        public int StoreId { get; set; }


        /// <summary>
        /// 性别0-保密，1-男，2-女
        /// </summary>
        public GenderEnum Gender { get; set; }



        public ServiceTypeEnum ServiceType { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Telephone { get; set; }



        /// <summary>
        /// 好评率
        /// </summary>
        public decimal Score { get; set; }



        /// <summary>
        /// 虚拟预约数量
        /// </summary>        
        public int FictitiousReserveNum
        {
            get;
            set;
        }


        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal WorkYears { get; set; }


        /// <summary>
        /// 简介
        /// </summary>
        public string Introduction { get; set; }

    }
}
