﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 门店表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Stores
    {
        /// <summary>
        /// 门店编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 门店名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 门店电话
        /// </summary>        
        public string Tel
        {
            get;
            set;
        }

        /// <summary>
        /// 门店地址
        /// </summary>        
        public string Address
        {
            get;
            set;
        }

        /// <summary>
        /// 门店经度纬度
        /// </summary>        
        public string LngLat
        {
            get;
            set;
        }

        /// <summary>
        /// 门店评分
        /// </summary>        
        public int? Score
        {
            get;
            set;
        }

        /// <summary>
        /// 门店介绍
        /// </summary>        
        public string Intro
        {
            get;
            set;
        }

        /// <summary>
        /// 门店封面图
        /// </summary>        
        public string CoverImg
        {
            get;
            set;
        }

        /// <summary>
        /// 门店轮播图
        /// </summary>        
        public string NavImg
        {
            get;
            set;
        }

        /// <summary>
        /// 营业开始时间
        /// </summary>        
        public string StartTime
        {
            get;
            set;
        }

        /// <summary>
        /// 营业结束时间
        /// </summary>        
        public string EndTime
        {
            get;
            set;
        }

        /// <summary>
        /// 是否全天营业(1-是)
        /// </summary>        
        public int? IsAllDay
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 服务项目
        /// </summary>
        public string ServiceProject { get; set; }

        /// <summary>
        /// 经度
        /// </summary>
        public float Lng { get; set; }

        /// <summary>
        /// 纬度
        /// </summary>
        public float Lat { get; set; }
    }
}
