﻿using Mall.Common.Enum.TradePavilion;
using Mall.Common.Plugin;
using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 商会活动报名扩展实体类
    /// </summary>
    public class RB_Commerce_Consult_Extend : RB_Commerce_Consult
    {
        /// <summary>
        /// 活动编号【查询使用】
        /// </summary>
        public string QActivityIds { get; set; }

        /// <summary>
        /// 用户编号【查询使用】
        /// </summary>
        public string QUserIds { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public string CreateTimeStr { get { return Common.ConvertHelper.FormatTime(this.CreateTime); } }

        /// <summary>
        /// 报名状态   1正常  2取消  3查询所有
        /// </summary>
        public int EnrollState { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityName { get; set; }

        /// <summary>
        /// 活动封面图
        /// </summary>
        public string CoverImg { get; set; }
        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime? StartTime { get; set; }
        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime? EndTime { get; set; }

        /// <summary>
        /// 类型名称
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// 性质名称
        /// </summary>
        public string NatureName { get { return this.Nature.GetEnumName(); } }

        /// <summary>
        /// 用户数量
        /// </summary>
        public int UserCount { get; set; }
    }

    /// <summary>
    /// 首店活动报名
    /// </summary>

    public class FirstShopConsult
    {
        /// <summary>
        /// 单位/企业/机构名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public NatureEnum? Nature { get; set; }

        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }


        /// <summary>
        /// 报名人信息
        /// </summary>
        public List<FirstShopLinkManModel> FirstShopLinkManList { get; set; }
    }


    /// <summary>
    /// 首店活动报名
    /// </summary>
    public class FirstShopLinkManModel
    {

        /// <summary>
        /// 联系人
        /// </summary>
        public string LinkMan { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string LinkTel { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Post { get; set; }


        /// <summary>
        /// 所属国籍/省/市
        /// </summary>
        public string CountryInfo { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 身份证号码
        /// </summary>
        public string IdCard { get; set; }

        /// <summary>
        /// 是否完成新冠病毒疫苗全程接种【1是/0否】
        /// </summary>
        public int IsInoculate { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史。【1是/0否】
        /// </summary>
        public int IsGATLJ { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史【备注】
        /// </summary>
        public string GATLJRemark { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【1是/0否】
        /// </summary>
        public int IsZGFX { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【备注】
        /// </summary>
        public string ZGFXRemark { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【1是/0否】
        /// </summary>
        public int IsQZJC { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【备注】
        /// </summary>
        public string QZJCRemark { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【1是/0否】
        /// </summary>
        public int IsJJGLGX { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【备注】
        /// </summary>
        public string JJGLGXRemark { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【1是/0否】
        /// </summary>
        public int IsZYCYJCGL { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【备注】
        /// </summary>
        public string ZYCYJCGLRemark { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【1是/0否】
        /// </summary>
        public int IsMJ { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【备注】
        /// </summary>
        public string MJRemark { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【1是/0否】
        /// </summary>
        public int IsFRGK { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【备注】
        /// </summary>
        public string FRGKRemark { get; set; }
    }

    /// <summary>
    /// 报名信息
    /// </summary>
    public class ActivityUserItem
    { 
        /// <summary>
        /// 小程序用户编号
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 小程序用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 认证状态
        /// </summary>
        public string CompanyStatusStr { get; set; }

        /// <summary>
        /// 认证公司名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 认证品牌/认证载体
        /// </summary>
        public string FirstShopTypeName { get; set; }

        /// <summary>
        /// 认证名称
        /// </summary>
        public string AuthName { get; set; }

        /// <summary>
        /// 跨行
        /// </summary>
        public int RowSpan { get; set; }

        /// <summary>
        /// 报名用户列表
        /// </summary>
        public List<SignUserItem> SignUserList { get; set; }
    }

    /// <summary>
    /// 报名详情
    /// </summary>
    public class SignUserItem
    {
        /// <summary>
        /// 报名编号
        /// </summary>
       public int Id { get; set; }

        /// <summary>
        /// 活动编号
        /// </summary>
        public int ActivityId { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string LinkMan { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string LinkTel { get; set; }

        /// <summary>
        /// 岗位
        /// </summary>
        public string Post { get; set; }

        /// <summary>
        /// 地址信息
        /// </summary>
        public string CountryInfo { get; set; }

        /// <summary>
        /// 公司名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public string Nature { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 身份证号码
        /// </summary>
        public string IdCard { get; set; }

        /// <summary>
        /// 是否完成新冠病毒疫苗全程接种【1是/0否】
        /// </summary>
        public int IsInoculate { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史。【1是/0否】
        /// </summary>
        public int IsGATLJ { get; set; }

        /// <summary>
        /// 活动前21天有港台地区和国外旅居史【备注】
        /// </summary>
        public string GATLJRemark { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【1是/0否】
        /// </summary>
        public int IsZGFX { get; set; }

        /// <summary>
        /// 活动前14天内有境内中高风险地区及所在县（市、区）旅居史【备注】
        /// </summary>
        public string ZGFXRemark { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【1是/0否】
        /// </summary>
        public int IsQZJC { get; set; }

        /// <summary>
        /// 活动前14天有来自新冠肺炎确诊病例、无症状感染者报告社区的发热和/或有呼吸道症状患者接触史【备注】
        /// </summary>
        public string QZJCRemark { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【1是/0否】
        /// </summary>
        public int IsJJGLGX { get; set; }

        /// <summary>
        /// 活动前14天有居家隔离医学观察人员接触史【备注】
        /// </summary>
        public string JJGLGXRemark { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【1是/0否】
        /// </summary>
        public int IsZYCYJCGL { get; set; }

        /// <summary>
        /// 已治愈出院的确诊病例和已解除集中隔离医学观察的无症状感染者，尚在随访或医学观察期内【备注】
        /// </summary>
        public string ZYCYJCGLRemark { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【1是/0否】
        /// </summary>
        public int IsMJ { get; set; }

        /// <summary>
        /// 被判定为新冠肺炎病毒感染者（确诊病例或无症状感染者）的密切接触者和密接的密接【备注】
        /// </summary>
        public string MJRemark { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【1是/0否】
        /// </summary>
        public int IsFRGK { get; set; }

        /// <summary>
        /// 有发热、干咳、乏力、咽痛、嗅（味）觉减退、腹泻等症状，且未排除传染病感染者【备注】
        /// </summary>
        public string FRGKRemark { get; set; }
    }
}
