﻿using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 拼团配置扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GroupBuyConfig_Extend : RB_GroupBuyConfig
    {
        /// <summary>
        /// 支付方式[online_pay-线上支付,huodao-货到付款,balance-余额支付]
        /// </summary>
        public List<string> Payment_TypeList
        {
            get;
            set;
        }

        /// <summary>
        /// 发货方式[express-快递配送,offline-到店自提,city-同城配送]
        /// </summary>
        public List<string> Send_TypeList
        {
            get;
            set;
        }

        /// <summary>
        /// 轮播图列表
        /// </summary>
        public List<GroupBuyBannerItem> BannerList { get; set; }

        /// <summary>
        /// 广告列表
        /// </summary>
        public List<GroupBuyMagicItem> MagicDataList { get; set; }
    }

    /// <summary>
    /// 拼团配置-轮播图
    /// </summary>
    public class GroupBuyBannerItem
    {
        /// <summary>
        /// 导航图标
        /// </summary>
        public string NavImg { get; set; }

        /// <summary>
        /// 导航链接
        /// </summary>
        public string NavLink { get; set; }

        /// <summary>
        /// 导航名称
        /// </summary>
        public string NavName { get; set; }

    }

    /// <summary>
    /// 拼团配置-广告
    /// </summary>
    public class GroupBuyMagicItem
    {
        /// <summary>
        /// 图片地址
        /// </summary>
        public string ImgUrl { get; set; }

        /// <summary>
        /// 链接地址
        /// </summary>
        public string Link { get; set; }

        /// <summary>
        /// 大小
        /// </summary>
        public string size { get; set; }
    }
}