﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 财务单据凭证仓储层
    /// </summary>
    public class RB_VoucherRepository : BaseRepository<RB_Voucher>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Voucher); } }

        /// <summary>
        /// 获取单据凭证列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Voucher_Extend> GetList(RB_Voucher_Extend model)
        {
            string where = " WHERE 1=1 ";
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Voucher.Type) + "={0} ", (int)model.Type);
            }
            if (model.FinanceId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Voucher.FinanceId) + "={0} ", model.FinanceId);
            }
            if (!string.IsNullOrWhiteSpace(model.FrIdStr))
            {
                where += string.Format(" AND " + nameof(RB_Voucher.FinanceId) + " in({0}) ", model.FrIdStr);
            }
            if (model.TradeWayId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Voucher.TradeWayId) + "={0} ", model.TradeWayId);
            }
            return Get<RB_Voucher_Extend>("select * from " + TableName + " " + where).ToList();
        }
    }
}
