﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_CardBagRepository : BaseRepository<RB_Reserve_CardBag>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_CardBag); } }


        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetCardBagPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as  SmallShopName FROM {TableName} as A  LEFT JOIN rb_smallshops_info as b on a.SmallShopId=b.Id WHERE  a.{nameof(RB_Reserve_CardBag_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CardBag_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CardBag_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_CardBag_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_CardBag_Extend.ID)} desc");
            return GetPage<RB_Reserve_CardBag_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 卡券信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetCardBagList(RB_Reserve_CardBag_Extend query, bool IsSelectDel = false)
        {
            StringBuilder builder = new StringBuilder();
            if (IsSelectDel)
            {
                builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            }
            else
            {
                builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Reserve_CardBag_Extend.Status)}=0 ");
            }
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CardBag_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CardBag_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_CardBag_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Reserve_CardBag_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrEmpty(query.CouponIds))
                {
                    builder.Append($" AND {nameof(RB_Reserve_CardBag_Extend.ID)} in({query.CouponIds})");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND  ( FIND_IN_SET('{query.StoreId}', {nameof(RB_Reserve_CardBag_Extend.StoreIds)}) or  FIND_IN_SET('0',  {nameof(RB_Reserve_CardBag_Extend.StoreIds)} )) ");
                }
                else if (query.StoreId != -1)
                {
                    builder.Append($" AND FIND_IN_SET('0',  {nameof(RB_Reserve_CardBag_Extend.StoreIds)})");
                }
            }
            return Get<RB_Reserve_CardBag_Extend>(builder.ToString()).ToList();
        }




        #region 小程序个人中心-领劵中心

        /// <summary>
        /// 领劵中心优惠券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetAllCardBagList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            string where = "   where a.`Status`=0   and a.PickupCenter=1 and a.EndDate>NOW()";
            string userWhere = "";//分类
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_CardBag_Extend.TenantId)}={query.TenantId}";

                    userWhere += $" AND {nameof(RB_Reserve_CardBag_Extend.TenantId)}={query.TenantId}";
                }
                if (query.MallBaseId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_CardBag_Extend.MallBaseId)}={query.MallBaseId}";
                    userWhere += $" AND {nameof(RB_Reserve_CardBag_Extend.MallBaseId)}={query.MallBaseId}";
                }
                if (query.UserId > 0)
                {
                    userWhere += $" AND {nameof(RB_Reserve_CardBag_Extend.UserId)}={query.UserId}";
                }
                if (query.SmallShopId > 0)
                {
                    where += $" AND ( a.{nameof(RB_Reserve_CardBag_Extend.SmallShopId)}={query.SmallShopId} or ( a.{nameof(RB_Reserve_CardBag_Extend.SmallShopId)}=0 and a.{nameof(RB_Reserve_CardBag_Extend.IsZanYangUse)}=0))";

                }
                else
                {
                    where += $" AND a.{nameof(RB_Reserve_CardBag_Extend.SmallShopId)}=0";
                }


                if (query.StoreId > 0)
                {
                    where += $" AND  ( FIND_IN_SET('{query.StoreId}', a.{nameof(RB_Reserve_CardBag_Extend.StoreIds)}) or  FIND_IN_SET('0', a.{nameof(RB_Reserve_CardBag_Extend.StoreIds)} )) ";
                }
                else
                {
                    where += $"  AND FIND_IN_SET('0', a.{nameof(RB_Reserve_CardBag_Extend.StoreIds)})";
                }
            }
            string sql = @$" 
SELECT a.ID,a.`Name`,a.`Describe`,a.StartDate,a.EndDate,a.CardBagIco,a.CardNo,c.MemberNum from rb_reserve_cardbag as a 
LEFT JOIN (SELECT CouponId,COUNT(*) as MemberNum from RB_Reserve_MemberCardBag where `Status`=0  {userWhere} GROUP BY CouponId) as c
on a.ID=c.CouponId {where}";
            return GetPage<RB_Reserve_CardBag_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }



        /// <summary>
        /// 领劵中心优惠券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetMemberCardBagList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            string where = "   where a.`Status`=0 and b.Status=0  ";
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCardBag.TenantId)}={query.TenantId}";

                    where += $" AND b.{nameof(RB_Reserve_CardBag_Extend.TenantId)}={query.TenantId}";
                }
                if (query.MallBaseId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCardBag.MallBaseId)}={query.MallBaseId}";
                    where += $" AND b.{nameof(RB_Reserve_CardBag_Extend.MallBaseId)}={query.MallBaseId}";
                }
                if (query.UserId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCardBag.UserId)}={query.UserId}";
                }

                if (query.StartDate.HasValue)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCardBag.CreateDate)}>='{query.StartDate.Value:yyyy-MM-dd HH:mm:ss}'";
                }
                if (query.EndDate.HasValue)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCardBag.CreateDate)}<='{query.EndDate.Value:yyyy-MM-dd HH:mm:ss}'";
                }
                //if (query.UseState == 0)
                //{
                //    where += $" AND a.{nameof(RB_Reserve_MemberCardBag_Extend.UseState)}={query.UseState} AND a.{nameof(RB_Reserve_MemberCardBag_Extend.EndDate)}> NOW()";
                //}
                //else if (query.UseState == 1)
                //{
                //    where += $" AND a.{nameof(RB_Reserve_MemberCardBag_Extend.UseState)}={query.UseState}";
                //}
                //else if (query.UseState == 2)
                //{
                //    where += $" AND a.{nameof(RB_Reserve_MemberCardBag_Extend.EndDate)}<NOW()   AND a.{nameof(RB_Reserve_MemberCardBag_Extend.UseState)}=0";
                //}
            }
            string sql = @$"  SELECT a.ID as MemberCouponId,a.StartDate,a.EndDate,b.ID,b.`Name`,b.`Describe`,b.CardBagIco,b.CardNo,a.CreateDate from RB_Reserve_MemberCardBag as a LEFT JOIN {TableName} as b 
on a.CouponId=b.ID {where} ";
            return GetPage<RB_Reserve_CardBag_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        #endregion


    }
}
