﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    public class RB_BrandClassRepository:BaseRepository<RB_BrandClass>
    {
        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_BrandClass_Extend> GetBrandClassPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_BrandClass_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_BrandClass
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_BrandClass_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.BrandCategory > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.BrandCategory), (int)query.BrandCategory);
                }
                if (!string.IsNullOrEmpty(query.ClassName))
                {
                    builder.AppendFormat(" AND {0} LIKE @ClassName ", nameof(RB_BrandClass_Extend.ClassName));
                    parameters.Add("@ClassName", "%" + query.ClassName.Trim() + "%");
                }
            }
            return GetPage<RB_BrandClass_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_BrandClass_Extend> GetBrandClassListRepository(RB_BrandClass_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_BrandClass
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_BrandClass_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.ClassName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_BrandClass_Extend.ClassName));
                    parameters.Add("Name", "%" + query.ClassName.Trim() + "%");
                }
                if (query.BrandCategory > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.BrandCategory), (int)query.BrandCategory);
                }
                if (query.ID > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_BrandClass_Extend.ID), query.ID);
                }
               
            }
            return Get<RB_BrandClass_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
