﻿using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 【商载通】 楼宇、载体地铁 仓储层
    /// </summary>
    public class RB_Building_CarriermetroRepository : BaseRepository<RB_Building_Carriermetro>
    {
        /// <summary>
        /// 【商载通】 楼宇、载体地铁 信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Building_Carriermetro_Extend> GetBuildingCarrierMetroListRepository(RB_Building_Carriermetro_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Building_Carriermetro WHERE {nameof(RB_Building_Carriermetro_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CarrierId > 0)
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.CarrierId)}={query.CarrierId}");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroNum))
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.MetroNum)} like '%{query.MetroNum}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.MetroName)} like '%{query.MetroName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierIds))
                {
                    builder.Append($" AND {nameof(RB_Building_Carriermetro_Extend.CarrierId)} in({query.CarrierIds})  ");
                }
            }
            return Get<RB_Building_Carriermetro_Extend>(builder.ToString()).ToList();
        }
    }
}
