﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using Dnc.Api.Throttle;
using Mall.CacheManager.Base;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Options;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NPOI.SS.Formula.Functions;
using SharpCompress.Common;
using static Google.Protobuf.WellKnownTypes.Field;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();


        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 韩国馆新闻处理类
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();
        /// <summary>
        /// 韩国馆新闻处理类
        /// </summary>
        private readonly CarrierModule carrierModule = new CarrierModule();
        /// <summary>
        /// 认证对象
        /// </summary>
        private readonly AuthenticationModule authenticationModule = new AuthenticationModule();

        /// <summary>
        /// Fat资料处理类对象
        /// </summary>
        private readonly CommerceAskModule askModule = new CommerceAskModule();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly Module.User.UserModule userModule = new Module.User.UserModule();
        /// <summary>
        /// 榜单
        /// </summary>
        private readonly FirstShopListModule firstShopListModule = new FirstShopListModule();
        /// <summary>
        /// 心愿单
        /// </summary>
        private readonly FirstShopWishModule firstShopWishModule = new FirstShopWishModule();

        private readonly BuildingCarrierModule buildingCarrierModule = new BuildingCarrierModule();

        RedisHelper redisHelper = new RedisHelper();


        #region 联系人管理

        /// <summary>
        /// 获取联系人分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetContractPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取联系人列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetContractList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractListModule(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult SetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Contract_Extend()
            {
                Id = parms.GetInt("Id"),
                Name = parms.GetStringValue("Name"),
                Tel = parms.GetStringValue("Tel"),
                HeadIcon = parms.GetStringValue("HeadIcon"),
                BgImg = parms.GetStringValue("BgImg"),
                Position = parms.GetStringValue("Position"),
                Intro = parms.GetStringValue("Intro")
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = module.SetContractModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = module.GetContractModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = module.RemoveContractModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_InvestmentProcurement_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                Type = parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }



        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除投资采购信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = procurementModule.RemoveInvestmentProcurementModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 投资采购审核
        /// </summary>
        /// <returns></returns>
        public ApiResult AutitInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var extModel = new RB_InvestmentProcurement_Extend()
            {
                Id = parms.GetInt("Id"),
                AuditStatus = parms.GetInt("AuditStatus"),
                AuditTime = DateTime.Now,
                AuditBy = Uid,
                AuditContent = parms.GetStringValue("AuditContent")
            };
            var flag = procurementModule.AuditInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 公司信息管理

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompanyPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Company_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyStatus = parms.GetInt("CompanyStatus", -1),
                CreateBy = parms.GetInt("CreateBy", 0),
                IsComplete = 1//需是 已完善了资料的
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = companyModule.GetCompanyPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取公司信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var extModel = companyModule.GetCompanyModule(CompanyId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = companyModule.RemoveCompanyModule(CompanyId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 审核公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateCompanyStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("CompanyStatus", 0);
            var Remark = parms.GetStringValue("Remark");//不通过备注
            var model = companyModule.GetCompanyEntity(CompanyId);
            if (model == null || model.CompanyId <= 0)
            {
                return ApiResult.Failed("公司信息不存在");
            }
            if (Status != 1 && Status != 2)
            {
                return ApiResult.Failed("状态有误");
            }
            if (Status == 2 && string.IsNullOrEmpty(Remark))
            {
                return ApiResult.ParamIsNull("请输入不通过的原因");
            }
            if (model.CompanyStatus == 1)
            {
                return ApiResult.Failed("公司信息已审核通过，请勿重复审核");
            }
            var msg = companyModule.UpdateCompanyStatus(CompanyId, Status, Remark);
            if (msg == "" && Status > 0)//推送审核结果
            {
                //查询用户的信息
                var umodel = userModule.GetMemberUserInfo(model.CreateBy);
                if (umodel != null && !string.IsNullOrWhiteSpace(umodel.OpenId))
                {
                    DateTime dt1 = DateTime.Now;
                    List<string> openidList = new List<string>
                    {
                        umodel.OpenId
                    };
                    new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(model.TenantId, model.MallBaseId, openidList, Status == 1 ? "认证通过" : "认证失败", "企业认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                    DateTime dt2 = DateTime.Now;
                    LogHelper.Write("认证通知耗时：" + (dt2 - dt1).TotalSeconds);
                }
            }
            return msg == "" ? ApiResult.Success() : ApiResult.Failed(msg);
        }

        /// <summary>
        /// 设置用户为管理员
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMemberUserIsAdmin()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var UserId = parms.GetInt("UserId", 0);
            var IsAdmin = parms.GetInt("IsAdmin", 0);
            if (UserId <= 0)
            {
                return ApiResult.Failed("请传递用户id");
            }

            var msg = companyModule.SetMemberUserIsAdmin(UserId, IsAdmin);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }
        #endregion

        #region 商会活动管理

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                ActivityName = jObj.GetStringValue("ActivityName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query, isQuerySignup: true);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改商会活动
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivity()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Activity_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityName = jObj.GetStringValue("ActivityName"),
                StartTime = jObj.GetDateTime("StartTime"),
                EndTime = jObj.GetDateTime("EndTime"),
                CoverImg = jObj.GetStringValue("CoverImg"),
                ActivityType = jObj.GetInt("ActivityType"),
                ActivityInfo = jObj.GetStringValue("ActivityInfo"),
                SignStartTime = jObj.GetDateTime("SignStartTime"),
                SignEndTime = jObj.GetDateTime("SignEndTime"),
                IsFree = jObj.GetInt("IsFree", 1),
                Price = jObj.GetInt("Price", 0),
                IsCancelConfirm = jObj.GetInt("IsCancelConfirm", 2)
            };
            try
            {
                extModel.CommerceDetailsList = Common.Plugin.JsonHelper.DeserializeObject<List<RB_Commerce_Details_Extend>>(jObj.GetStringValue("CommerceDetailsList"));
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "SetCommerceActivity_CommerceDetailsList");
            }
            if (string.IsNullOrEmpty(extModel.ActivityName))
            {
                return ApiResult.Failed(message: "请填写活动名称!");
            }
            if (string.IsNullOrEmpty(jObj.GetStringValue("StartTime")))
            {
                return ApiResult.Failed(message: "请选择活动开始时间!");
            }
            if (string.IsNullOrEmpty(jObj.GetStringValue("EndTime")))
            {
                return ApiResult.Failed(message: "请选择活动结束时间!");
            }
            if (extModel.StartTime > extModel.EndTime)
            {
                return ApiResult.Failed(message: "活动开始时间不能大于结束时间!");
            }

            if (string.IsNullOrEmpty(jObj.GetStringValue("SignStartTime")))
            {
                return ApiResult.Failed(message: "请选择报名开始时间!");
            }
            if (string.IsNullOrEmpty(jObj.GetStringValue("SignEndTime")))
            {
                return ApiResult.Failed(message: "请选择报名结束时间!");
            }
            if (extModel.SignStartTime > extModel.SignEndTime)
            {
                return ApiResult.Failed(message: "活动报名开始时间不能大于结束时间!");
            }

            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.IsFree == 1)
            {
                extModel.Price = 0;
            }
            var flag = activityModule.SetCommerceActivityModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            list.ForEach(x => x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName));
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypeList()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            list.ForEach(x => x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName));
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改商会活动类型
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivityType()
        {
            RB_Commerce_ActivityType_Extend extModel = JsonConvert.DeserializeObject<RB_Commerce_ActivityType_Extend>(RequestParm.msg.ToString());
            //JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            //var extModel = new RB_Commerce_ActivityType_Extend()
            //{
            //    Id = jObj.GetInt("Id"),
            //    TypeName = jObj.GetStringValue("TypeName"),
            //    CoverImage=jObj.GetStringValue("CoverImage")
            //};
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.LableNameList != null && extModel.LableNameList.Any())
            {
                extModel.LableName = JsonConvert.SerializeObject(extModel.LableNameList);
            }
            else
            {
                extModel.LableName = "";
            }
            var flag = activityModule.SetCommerceActivityTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityTypeModule(Id);
            extModel.LableNameList = string.IsNullOrWhiteSpace(extModel.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(extModel.LableName);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动类型状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityTypeModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商会活动报名管理

        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsultPage()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                ActivityId = jObj.GetInt("ActivityId", 0),
                LinkMan = jObj.GetStringValue("LinkMan"),
                EnrollState = jObj.GetInt("EnrollState", 0)
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetConsultStaticPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                LinkMan = parms.GetStringValue("LinkMan"),
                ActivityId = parms.GetInt("ActivityId"),
                UserId = parms.GetInt("UserId", 0),
                CompanyName = parms.GetStringValue("CompanyName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 导出
        /// </summary>
        [HttpPost]
        public FileContentResult DownLoadConsultStatic()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            pageModel.pageSize = 100000;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                LinkMan = parms.GetStringValue("LinkMan"),
                ActivityId = parms.GetInt("ActivityId")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultPageModule(pageModel.pageIndex, pageModel.pageSize, out _, query);
            string ExcelName = "活动用户导出" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                   new ExcelColumn(value: "用户昵称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证状态") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证公司") { CellWidth = 25, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证信息") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "公司") { CellWidth = 25, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "性质") { CellWidth = 20, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "联系人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "联系电话") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "职务") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "地址") { CellWidth = 30, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                },
            };
            slist.Add(header);
            try
            {
                #region 组装数据
                foreach (var item in list)
                {
                    int index = 0;
                    foreach (var sItem in item.SignUserList)
                    {
                        var excelColumns = new List<ExcelColumn>(30);
                        if (index == 0)
                        {
                            excelColumns.Add(new ExcelColumn(value: item.UserName) { Rowspan = item.RowSpan });
                            excelColumns.Add(new ExcelColumn(value: item.CompanyStatusStr) { Rowspan = item.RowSpan });
                            excelColumns.Add(new ExcelColumn(value: item.CompanyName) { Rowspan = item.RowSpan });
                            excelColumns.Add(new ExcelColumn(value: item.AuthName) { Rowspan = item.RowSpan });
                        }
                        else
                        {
                            excelColumns.Add(new ExcelColumn(value: ""));
                            excelColumns.Add(new ExcelColumn(value: ""));
                            excelColumns.Add(new ExcelColumn(value: ""));
                            excelColumns.Add(new ExcelColumn(value: ""));
                        }
                        excelColumns.Add(new ExcelColumn(value: sItem.CompanyName));
                        excelColumns.Add(new ExcelColumn(value: sItem.Nature));
                        excelColumns.Add(new ExcelColumn(value: sItem.LinkMan));
                        excelColumns.Add(new ExcelColumn(value: sItem.LinkTel));
                        excelColumns.Add(new ExcelColumn(value: sItem.Post));
                        excelColumns.Add(new ExcelColumn(value: sItem.CountryInfo));
                        index++;
                        ExcelDataSource datarow = new ExcelDataSource()
                        {
                            ExcelRows = excelColumns
                        };
                        slist.Add(datarow);
                    }
                }
                #endregion
                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("DownLoadConsultStatic_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
        }


        /// <summary>
        /// 导出
        /// </summary>
        [HttpPost]
        public FileContentResult DownLoadConsultStaticNew()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            pageModel.pageSize = 100000;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                LinkMan = parms.GetStringValue("LinkMan"),
                ActivityId = parms.GetInt("ActivityId")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultPageModule(pageModel.pageIndex, pageModel.pageSize, out _, query);
            string ExcelName = "活动用户导出" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                   new ExcelColumn(value: "用户昵称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证状态") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证公司") { CellWidth = 25, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "认证信息") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "公司") { CellWidth = 25, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "性质") { CellWidth = 20, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "联系人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "联系电话") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "职务") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                   new ExcelColumn(value: "地址") { CellWidth = 30, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                },
            };
            slist.Add(header);
            try
            {
                #region 组装数据
                foreach (var item in list)
                {
                    foreach (var sItem in item.SignUserList)
                    {
                        var excelColumns = new List<ExcelColumn>(30)
                        {
                            new ExcelColumn(value: item.UserName),
                            new ExcelColumn(value: item.CompanyStatusStr),
                            new ExcelColumn(value: item.CompanyName),
                            new ExcelColumn(value: item.AuthName),
                            new ExcelColumn(value: sItem.CompanyName),
                            new ExcelColumn(value: sItem.Nature),
                            new ExcelColumn(value: sItem.LinkMan),
                            new ExcelColumn(value: sItem.LinkTel),
                            new ExcelColumn(value: sItem.Post),
                            new ExcelColumn(value: sItem.CountryInfo)
                        };

                        ExcelDataSource datarow = new ExcelDataSource()
                        {
                            ExcelRows = excelColumns
                        };
                        slist.Add(datarow);
                    }
                }
                #endregion
                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("DownLoadConsultStatic_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
        }


        /// <summary>
        /// 根据编号获取商会活动报名实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = consultModule.GetCommerceConsultModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商会活动报名状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = consultModule.RemoveCommerceConsultModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 操作商会活动报名申请取消
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsultApplyCancel()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var ApplyForCancelStatus = parms.GetInt("ApplyForCancelStatus", 0);//申请取消审核状态  1同意  2拒绝
            var RejectRemark = parms.GetStringValue("RejectRemark");//拒绝备注
            if (Id <= 0)
            {
                return ApiResult.ParamIsNull("请传递");
            }
            if (ApplyForCancelStatus == 2)
            {
                if (string.IsNullOrEmpty(RejectRemark))
                {
                    return ApiResult.ParamIsNull("请输入拒绝的原因");
                }
            }
            var flag = consultModule.SetCommerceConsultApplyCancel(Id, ApplyForCancelStatus, RejectRemark);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 新闻信息管理

        /// <summary>
        /// 获取新闻信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNewsPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_News_Extend()
            {
                Title = parms.GetStringValue("Title"),
                Type = parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = commerceNewsModule.GetCommerceNewsPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除新闻信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = commerceNewsModule.RemoveCommerceNewsModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增修改新闻
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceNews()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_News_Extend()
            {
                Id = jObj.GetInt("Id"),
                CoverImg = jObj.GetStringValue("CoverImg"),
                Title = jObj.GetStringValue("Title"),
                Industry = jObj.GetStringValue("Industry"),
                PublishTime = jObj.GetDateTime("PublishTime"),
                NewsInfo = jObj.GetStringValue("NewsInfo"),
                Type = jObj.GetInt("Type"),
                Subtitle = jObj.GetStringValue("Subtitle"),
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = commerceNewsModule.SetCommerceNewsModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 咨询管理
        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Ask_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = askModule.GetCommerceAskPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = askModule.GetCommerceAskModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult ReplyCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var model = new RB_Commerce_Ask_Extend()
            {
                Id = parms.GetInt("Id", 0),
                AskStatus = parms.GetInt("AskStatus"),
                ReplyTime = DateTime.Now,
                FatContent = parms.GetStringValue("FatContent"),
                ReplyId = Uid
            };
            var extModel = askModule.ReplyCommerceAskModule(model);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 认证管理

        /// <summary>
        /// 获取认证分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationPageList()
        {
            var parms = RequestParm;
            var userInfo = this.UserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(parms.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = authenticationModule.GetAuthenticationPageList_V2(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            List<RB_Brand_Extend> brandList = new List<RB_Brand_Extend>();

            if (list != null && list.Any())
            {
                string brandIds = string.Join(",", list.Where(x => x.ExistBrandId > 0).Select(x => x.ExistBrandId));
                if (!string.IsNullOrEmpty(brandIds))
                {
                    var query = new RB_Brand_Extend()
                    {
                        BrandIds = brandIds,
                    };
                    query.MallBaseId = userInfo.MallBaseId;
                    query.TenantId = userInfo.TenantId;
                    query.RanQi = -1;
                    query.KongTiao = -1;
                    query.XinFeng = -1;
                    query.Plumbing = -1;
                    query.Caliber = -1;
                    query.PaiYan = -1;
                    query.Sewage = -1;
                    brandList = carrierModule.GetBrandListByWhere(query);
                    if (brandList != null && brandList.Any())
                    {
                        foreach (var item in list)
                        {
                            var nowBrand = brandList.Where(x => x.ID == item.ExistBrandId).FirstOrDefault();
                            if (item.AuditState == 2)
                            {
                                if (nowBrand != null && nowBrand.ID > 0 && !string.IsNullOrWhiteSpace(nowBrand.SourceIds))
                                {
                                    item.ExistBrandId = 0;
                                }

                            }

                        }
                    }
                }

            }

            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.CoverImage,
                x.ImageList,
                x.VideoUrl,
                x.Type,
                TypeName = x.Type.GetEnumName(),
                x.BrandType,
                BrandTypeName = x.BrandType.GetEnumName(),
                OpenTime = x.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.TradingArea,
                x.BusinessType,
                BusinessTypeName = x.BusinessType.GetEnumName(),
                x.BusinessDetail,
                x.Description,
                x.County,
                x.Category,
                CategoryName = x.Category.GetEnumName(),
                x.Contact,
                x.ContactMobile,
                x.AuditState,
                x.AuditRemark,
                AuditDate = x.AuditDate.HasValue ? x.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.CreateName,
                x.CreatePhoto,
                x.ExistBrandId
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 认证Excel下载
        /// </summary>
        [HttpPost]
        public FileContentResult GetAuthenticationListToExcel()
        {
            var userInfo = this.UserInfo;
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(RequestParm.msg.ToString());
            string ExcelName = "首店申请" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "首店名称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "封面图") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "图片") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "视频") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "品牌归属地") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "开业时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "详细地址") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商圈") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "行业") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "首店业种类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "简介") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "所在区县") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "类别") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "联系人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "联系电话") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "审核状态") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "申请时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                }
            };

            slist.Add(header);

            try
            {
                demodel.TenantId = userInfo.TenantId;
                demodel.MallBaseId = userInfo.MallBaseId;
                var list = authenticationModule.GetAuthenticationPageList_V2(1, 100000, out long count, demodel);
                #region 组装数据
                foreach (var item in list)
                {
                    string AuditState = "审核中";
                    if (item.AuditState == 2)
                    {
                        AuditState = "通过";
                    }
                    else if (item.AuditState == 3)
                    {
                        AuditState = "不通过";
                    }
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:item.Name){ },
                            new ExcelColumn(value:item.CoverImage){ },
                            new ExcelColumn(value:item.Images){ },
                            new ExcelColumn(value:item.VideoUrl){ },
                            new ExcelColumn(value:item.Type.GetEnumName()){ },
                            new ExcelColumn(value:item.BrandType.GetEnumName()){ },
                            new ExcelColumn(value:item.OpenTime.ToString("yyyy-MM-dd HH:mm")){ },
                            new ExcelColumn(value:item.Address){ },
                            new ExcelColumn(value:item.TradingArea){ },
                            new ExcelColumn(value:item.BusinessType.GetEnumName()){ },
                            new ExcelColumn(value:item.BusinessDetail){ },
                            new ExcelColumn(value:item.Description){ },
                            new ExcelColumn(value:item.County){ },
                            new ExcelColumn(value:item.Category.GetEnumName()){ },
                            new ExcelColumn(value:item.Contact){ },
                            new ExcelColumn(value:item.ContactMobile){ },
                            new ExcelColumn(value:AuditState){ },
                            new ExcelColumn(value:item.CreateDate.ToString("yyyy-MM-dd HH:mm")){ }
                        }
                    };
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 获取认证详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            var model = authenticationModule.GetAuthenticationInfo(AuthenticationId);


            if (model == null) { return ApiResult.Failed("认证不存在"); }
            //获取品牌名称
            string brandName = "";
            if (model.ExistBrandId > 0)
            {
                var query = new RB_Brand_Extend()
                {
                    ID = model.ExistBrandId,

                };
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
                query.RanQi = -1;
                query.KongTiao = -1;
                query.XinFeng = -1;
                query.Plumbing = -1;
                query.Caliber = -1;
                query.PaiYan = -1;
                query.Sewage = -1;
                var extModel = carrierModule.GetBrand(query);
                if (extModel != null && extModel.ID > 0)
                {
                    brandName = extModel.BrandName;
                }
            }


            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.CoverImage,
                model.ImageList,
                model.VideoUrl,
                model.Type,
                TypeName = model.Type.GetEnumName(),
                model.BrandType,
                BrandTypeName = model.BrandType.GetEnumName(),
                OpenTime = model.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                model.Address,
                model.TradingArea,
                model.BusinessType,
                BusinessTypeName = model.BusinessType.GetEnumName(),
                model.BusinessDetail,
                model.Description,
                model.County,
                model.Category,
                CategoryName = model.Category.GetEnumName(),
                model.Contact,
                model.ContactMobile,
                model.AuditState,
                model.AuditRemark,
                AuditDate = model.AuditDate.HasValue ? model.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = model.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                model.ExistBrandId,
                BrandName = brandName
            });
        }

        /// <summary>
        /// 认证审核
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAuthenticationAudit()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            int AuditState = parms.GetInt("AuditState", 0);//审核状态  2审核通过   3审核不通过
            string AuditRemark = parms.GetStringValue("AuditRemark");

            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            if (AuditState != 2 && AuditState != 3)
            {
                return ApiResult.Failed("状态有误");
            }
            bool flag = authenticationModule.SetAuthenticationAudit(AuthenticationId, AuditState, AuditRemark);
            if (flag)
            {
                //查询用户的信息
                var model = authenticationModule.GetAuthenticationInfo(AuthenticationId);
                var umodel = userModule.GetMemberUserInfo(model.CreateBy);
                if (umodel != null && !string.IsNullOrWhiteSpace(umodel.OpenId))
                {
                    List<string> openidList = new List<string>
                    {
                        umodel.OpenId
                    };
                    new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(model.TenantId, model.MallBaseId, openidList, AuditState == 2 ? "认证通过" : "认证失败", "首店认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                }
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 批量认证审核
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult BatchAuthenticationAudit()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var userInfo = this.UserInfo;
            string AuthenticationIds = parms.GetStringValue("AuthenticationIds");
            int AuditState = parms.GetInt("AuditState", 0);//审核状态  2审核通过   3审核不通过
            string AuditRemark = parms.GetStringValue("AuditRemark");

            if (string.IsNullOrWhiteSpace(AuthenticationIds))
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            if (AuditState != 2 && AuditState != 3)
            {
                return ApiResult.Failed("状态有误");
            }

            var list = authenticationModule.GetAuthenticationList(new RB_Authentication_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId, Ids = AuthenticationIds });
            if (list == null || !list.Any())
            {
                return ApiResult.Failed("请传入正确的id");
            }
            if (list.Any(x => x.AuditState > 1))
            {
                return ApiResult.Failed("已审核的不能重复审核");
            }
            bool flag = authenticationModule.BatchAuthenticationAudit(AuthenticationIds, AuditState, AuditRemark);
            if (flag)
            {
                //查询用户的信息
                string uids = string.Join(",", list.Select(x => x.CreateBy));
                var memberList = userModule.GetMemberUserList(new Model.Extend.User.RB_Member_User_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId, UserIds = uids });
                if (memberList != null && memberList.Any())
                {
                    List<string> openidList = new List<string>();
                    foreach (var item in memberList)
                    {
                        if (!string.IsNullOrWhiteSpace(item.OpenId))
                        {
                            openidList.Add(item.OpenId);
                        }
                    }
                    if (openidList != null && openidList.Any())
                    {
                        new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(userInfo.TenantId, userInfo.MallBaseId, openidList, AuditState == 2 ? "认证通过" : "认证失败", "首店认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                    }
                }
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 批量设置奖项
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAuthenticationPrize()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var userInfo = this.UserInfo;
            string AuthenticationIds = parms.GetStringValue("AuthenticationIds");
            string SourceIds = parms.GetStringValue("SourceIds");
            if (string.IsNullOrWhiteSpace(AuthenticationIds))
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            var list = authenticationModule.GetAuthenticationList(new RB_Authentication_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId, Ids = AuthenticationIds });
            if (list == null || !list.Any())
            {
                return ApiResult.Failed("请传入正确的id");
            }
            if (list.Any(x => x.AuditState != 2))
            {
                return ApiResult.Failed("未审核/审核不通过的不能授予奖章");
            }
            var brandIds = string.Join(",", list.Where(x => x.ExistBrandId > 0).Select(x => x.ExistBrandId));
            bool flag = false;
            if (!string.IsNullOrWhiteSpace(brandIds))
            {
                flag = authenticationModule.SetAuthenticationPrize(brandIds, SourceIds);
            }

            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 载体信息
        /// <summary>
        /// 获取载体分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetCarrierPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                MetroName = parms.GetStringValue("MetroName"),
                CarrierName = parms.GetStringValue("CarrierName"),
                MetroNum = parms.GetInt("MetroNum", 0),
                Developers = parms.GetStringValue("Developers"),
                StartOpenTime = parms.GetStringValue("StartOpenTime"),
                EndOpenTime = parms.GetStringValue("EndOpenTime"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                UserId = parms.GetInt("UserId", 0),
                OpeningStatus = parms.GetInt("OpeningStatus", -1),
                FirstStoreTest = parms.GetInt("FirstStoreTest", -1),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetCarrierPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query, true);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.ID,
                x.CarrierName,
                x.Logo,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.LatAndLon,
                x.Developers,
                OpenTime = Common.ConvertHelper.FormatDate2(x.OpenTime),
                x.ProjectType,
                ProjectTypeName = x.ProjectType.GetEnumName(),
                x.CarrierSize,
                x.LayersNum,
                x.CarNum,
                x.CarrierPlan,
                x.CarrierTarget,
                x.Location,
                x.Crowd,
                x.VideoUrl,
                x.UserId,
                x.UserName,
                x.UserIcon,
                x.CarrierMetroList
            });
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取载体实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]

        [HttpPost]
        public ApiResult GetCarrierDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = carrierModule.GetCarrierModel(query);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改载体信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetCarrier()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Carrier_Extend query = new RB_Carrier_Extend()
            {
                ID = parms.GetInt("ID"),
                CarrierName = parms.GetStringValue("CarrierName"),
                Logo = parms.GetStringValue("Logo"),
                VideoUrl = parms.GetStringValue("VideoUrl"),
                Address = parms.GetStringValue("Address"),
                LatAndLon = parms.GetStringValue("LatAndLon"),
                Developers = parms.GetStringValue("Developers"),
                OpenTime = parms.GetDateTime("OpenTime"),
                ProjectType = (ProjectTypeEnum)parms.GetInt("ProjectType"),
                CarrierSize = parms.GetDecimal("CarrierSize"),
                LayersNum = parms.GetStringValue("LayersNum"),
                CarNum = parms.GetInt("CarNum"),
                CarrierPlan = parms.GetStringValue("CarrierPlan"),
                CarrierTarget = parms.GetStringValue("CarrierTarget"),
                Location = parms.GetStringValue("Location"),
                Crowd = parms.GetStringValue("Crowd"),
                Discount = parms.GetStringValue("Discount"),
                StartingInfo = parms.GetStringValue("StartingInfo"),
                ShopNum = parms.GetInt("ShopNum"),
                BuiltUpArea = parms.GetDecimal("BuiltUpArea"),
                AreaRequirement = parms.GetDecimal("AreaRequirement"),
                YeJi = parms.GetDecimal("YeJi"),
                OpeningStatus = parms.GetInt("OpeningStatus"),
            };
            string BannerList = parms.GetStringValue("BannerList");
            if (!string.IsNullOrEmpty(BannerList))
            {
                query.BannerList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(BannerList);
            }
            string CarrierMetroList = parms.GetStringValue("CarrierMetroList");
            query.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
            if (!string.IsNullOrEmpty(CarrierMetroList))
            {
                JArray jarray = JArray.Parse(CarrierMetroList);
                if (jarray != null && jarray.Count > 0)
                {
                    foreach (var jItem in jarray)
                    {
                        var sObj = JObject.Parse(jItem.ToString());
                        query.CarrierMetroList.Add(new RB_CarrierMetro_Extend()
                        {
                            ID = sObj.GetInt("ID"),
                            MetroNum = sObj.GetStringValue("MetroNum"),
                            MetroName = sObj.GetStringValue("MetroName"),
                            Distance = sObj.GetStringValue("Distance"),
                            CarrierId = sObj.GetInt("CarrierId"),
                            TenantId = sObj.GetInt("TenantId"),
                            MallBaseId = sObj.GetInt("MallBaseId"),
                            Status = (DateStateEnum)sObj.GetInt("Status"),
                            CarrierIds = sObj.GetStringValue("CarrierIds"),
                        });
                    }
                }
            }
            string FirstShopNumList = parms.GetStringValue("FirstShopNumList");
            query.FirstShopNumList = new List<FirstShopNumModel>();
            if (!string.IsNullOrEmpty(FirstShopNumList))
            {
                JArray jarray = JArray.Parse(FirstShopNumList);
                if (jarray != null && jarray.Count > 0)
                {
                    foreach (var jItem in jarray)
                    {
                        var sObj = JObject.Parse(jItem.ToString());
                        query.FirstShopNumList.Add(new FirstShopNumModel()
                        {
                            Id = sObj.GetInt("Id"),
                            Name = sObj.GetStringValue("Name"),
                            Num = sObj.GetInt("Num")
                        });
                    }
                }
            }
            string HonorList = parms.GetStringValue("HonorList");
            if (!string.IsNullOrEmpty(HonorList))
            {
                query.HonorList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(HonorList);
            }
            if (string.IsNullOrWhiteSpace(query.CarrierName))
            {
                return ApiResult.Failed("请输入载体名称");
            }
            if (string.IsNullOrWhiteSpace(query.Developers))
            {
                return ApiResult.Failed("请输入开发商");
            }
            if (string.IsNullOrWhiteSpace(query.Address))
            {
                return ApiResult.Failed("请输入项目地址");
            }
            if (!query.ShopNum.HasValue)
            {
                return ApiResult.Failed("请输入店铺数量");
            }
            if (!query.BuiltUpArea.HasValue)
            {
                return ApiResult.Failed("请输入经营面积");
            }
            if (!query.AreaRequirement.HasValue)
            {
                return ApiResult.Failed("请输入可租赁面积");
            }

            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }
            if (query.BannerList == null || !query.BannerList.Any())
            {
                return ApiResult.Failed("请上传介绍图");
            }
            //if (!query.OpenTime.HasValue)
            //{
            //    return ApiResult.Failed("请输入开业时间");
            //}
            if (!query.ProjectType.HasValue)
            {
                return ApiResult.Failed("请选择项目类型");
            }

            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            if (query.HonorList != null && query.HonorList.Any())
            {
                query.Honor = JsonConvert.SerializeObject(query.HonorList);
            }
            else
            {
                query.Honor = "";
            }
            if (query.FirstShopNumList != null && query.FirstShopNumList.Any())
            {
                query.FirstShopNum = JsonConvert.SerializeObject(query.FirstShopNumList);
            }
            else
            {
                query.FirstShopNum = "";
            }
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            if (!string.IsNullOrWhiteSpace(query.StartingInfo))
            {
                query.FirstStoreTest = 1;
            }
            else
            {
                query.FirstStoreTest = 0;
            }
            query.ShopNum ??= 0;
            query.BuiltUpArea ??= 0;
            query.EndBuiltUpArea ??= 0;
            query.AreaRequirement ??= 0;
            query.EndAreaRequirement ??= 0;
            query.YeJi ??= 0;
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetCarrier(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }



        /// <summary>
        /// 删除载体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCarrier()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("CarrierId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = carrierModule.RemoveCarrierModule(CarrierId, RequestParm.TenantId, RequestParm.MallBaseId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 获取载体下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCarrierExportEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.CarrierExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        #endregion


        #region 品牌管理


        /// <summary>
        /// 获取商品性质枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetProjectTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ProjectTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取品牌分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassPageList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            ResultPageModel pageModel = new ResultPageModel()
            {
                pageIndex = parms.GetInt("pageIndex"),
                pageSize = parms.GetInt("pageSize"),
            };
            var query = new RB_BrandClass_Extend()
            {
                ClassName = parms.GetStringValue("ClassName"),
                BrandCategory = (BrandCategoryEnum)parms.GetInt("BrandCategory"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            List<object> list = new List<object>();
            var dataList = carrierModule.GetBrandClassPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            foreach (var item in dataList)
            {
                list.Add(new
                {
                    item.ID,
                    item.ClassName,
                    item.Logo,
                    item.BrandCategory,
                    BrandCategoryName = item.BrandCategory.GetEnumName(),
                    CreateDate = Common.ConvertHelper.FormatTime(item.CreateDate),
                });
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取品牌分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_BrandClass_Extend
            {
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId,
                BrandCategory = (BrandCategoryEnum)parms.GetInt("BrandCategory"),
            };
            List<object> list = new List<object>();
            var dataList = carrierModule.GetBrandClassListModule(query);
            foreach (var item in dataList)
            {
                list.Add(new
                {
                    item.ID,
                    item.ClassName,
                    item.Logo,
                    item.BrandCategory,
                    BrandCategoryName = item.BrandCategory.GetEnumName(),
                });
            }
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int ID = parms.GetInt("ID", 0);
            if (ID <= 0)
            {
                return ApiResult.ParamIsNull(message: "请传递分类编号");
            }
            var extModel = carrierModule.GetBrandClassModule(ID);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetBrandClass()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_BrandClass_Extend query = new RB_BrandClass_Extend()
            {
                ID = parms.GetInt("ID"),
                Logo = parms.GetStringValue("Logo"),
                ClassName = parms.GetStringValue("ClassName"),
                BrandCategory = (BrandCategoryEnum)parms.GetInt("BrandCategory"),
            };
            if (string.IsNullOrWhiteSpace(query.ClassName))
            {
                return ApiResult.Failed("请输入分类名称");
            }
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetBrandClassModule(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除品牌信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveBrandClass()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("Id", 0);
            var flag = carrierModule.RemoveBrandClassModule(CarrierId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取品牌分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]

        public ApiResult GetBrandPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                BrandName = parms.GetStringValue("BrandName"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                BrandClassId = parms.GetInt("BrandClassId", 0),
                RanQi = parms.GetInt("RanQi", -1),
                KongTiao = parms.GetInt("KongTiao", -1),
                XinFeng = parms.GetInt("XinFeng", -1),
                Plumbing = parms.GetInt("Plumbing", -1),
                Caliber = parms.GetInt("Caliber", -1),
                Sewage = parms.GetInt("Sewage", -1),
                PaiYan = parms.GetInt("PaiYan", -1),
                DianLiang = parms.GetStringValue("DianLiang"),
                UserId = parms.GetInt("UserId", 0),
                PrizeId = parms.GetInt("PrizeId", -1),
            };
            if (!string.IsNullOrWhiteSpace(parms.GetStringValue("IsInChengdu")))
            {
                query.IsInChengdu = Convert.ToInt32(parms.GetStringValue("IsInChengdu"));
            }
            else
            {
                query.IsInChengdu = -1;
            }
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetBrandPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query, true);
            foreach (var item in list)
            {
                item.ProjectName = item.ProjectType.GetEnumName();
                if (!string.IsNullOrWhiteSpace(item.Banner))
                {
                    item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                }
                else
                {
                    item.BannerList = new List<string>();
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.RanQi = -1;
            query.KongTiao = -1;
            query.XinFeng = -1;
            query.Plumbing = -1;
            query.Caliber = -1;
            query.PaiYan = -1;
            query.Sewage = -1;
            var extModel = carrierModule.GetBrand(query);

            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            else
            {
                extModel.BannerList = new List<string>();
            }

            if (!string.IsNullOrWhiteSpace(extModel.Other))
            {
                extModel.Other = HtmlHelper.StripHT(extModel.Other);
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetBrand()
        {
            RB_Brand_Extend query = JsonConvert.DeserializeObject<RB_Brand_Extend>(RequestParm.msg.ToString());
            if (string.IsNullOrWhiteSpace(query.BrandName))
            {
                return ApiResult.Failed("请输入品牌名称");
            }
            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }

            if (query.BrandClassId == 0)
            {
                return ApiResult.Failed("请选择品牌分类");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetBrand(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveBrand()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("Id", 0);
            var flag = carrierModule.RemoveBrandModule(CarrierId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 检查品牌文件是否存在
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<ApiResult> CheckBrandFile()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var demodel = new RB_Brand_Extend()
            {
                BrandName = parms.GetStringValue("BrandName"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                BrandClassId = parms.GetInt("BrandClassId", 0),
                RanQi = parms.GetInt("RanQi", -1),
                KongTiao = parms.GetInt("KongTiao", -1),
                XinFeng = parms.GetInt("XinFeng", -1),
                Plumbing = parms.GetInt("Plumbing", -1),
                Caliber = parms.GetInt("Caliber", -1),
                Sewage = parms.GetInt("Sewage", -1),
                PaiYan = parms.GetInt("PaiYan", -1),
                DianLiang = parms.GetStringValue("DianLiang"),
            };
            demodel.MallBaseId = RequestParm.MallBaseId;
            demodel.TenantId = RequestParm.TenantId;
            string RandomNum = parms.GetStringValue("RandomNum");
            string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
            List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
            string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(demodel) + ExcelEnumIdsStr + ExcelEnumIdsStr);
            string fileName = "品牌信息" + ".xls";
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
            if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            string tempPath = filePath + "\\" + hashKey + "\\";
            //如果不存在就创建file文件夹
            if (!System.IO.Directory.Exists(tempPath))
            {
                System.IO.Directory.CreateDirectory(tempPath);
            }
            string fileUrl = tempPath + fileName;
            string key = "Mall_SD_BRAND_" + hashKey;
            string redisValue = redisHelper.StringGet(key);
            if (string.IsNullOrEmpty(redisValue))
            {
                redisValue = redisHelper.StringGet(key);
                if (string.IsNullOrEmpty(redisValue))
                {
                    redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
                    Task.Run(() =>
                    {
                        GetBrandListToExcel(demodel, ExcelEnumIds, tempPath, fileUrl);
                    });
                }
            }
            return await Task.Run<ApiResult>(() =>
            {
                ApiResult apiResult = new ApiResult()
                {
                    resultCode = 0,
                };
                if (System.IO.File.Exists(fileUrl))
                {
                    var filePath = "/upfile/temporary/" + hashKey + "/";
                    var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
                    apiResult.resultCode = 1;
                    apiResult.data = new { filePath, fileUrl };
                    apiResult.message = key;
                }
                return apiResult;
            });
        }

        /// <summary>
        /// 检查载体文件是否存在
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<ApiResult> CheckCarrierFile()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var demodel = new RB_Carrier_Extend()
            {
                MetroName = parms.GetStringValue("MetroName"),
                CarrierName = parms.GetStringValue("CarrierName"),
                MetroNum = parms.GetInt("MetroNum", 0),
                Developers = parms.GetStringValue("Developers"),
                StartOpenTime = parms.GetStringValue("StartOpenTime"),
                EndOpenTime = parms.GetStringValue("EndOpenTime"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0)
            };
            demodel.MallBaseId = RequestParm.MallBaseId;
            demodel.TenantId = RequestParm.TenantId;
            string RandomNum = parms.GetStringValue("RandomNum");
            string ExcelEnumIdsStr = parms.GetStringValue("ExcelEnumIds");
            List<int> ExcelEnumIds = JsonConvert.DeserializeObject<List<int>>(ExcelEnumIdsStr);
            string hashKey = Common.Config.GetHash(Common.Plugin.JsonHelper.Serialize(demodel) + ExcelEnumIdsStr + RandomNum);
            string fileName = "载体信息" + ".xls";
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile/temporary");
            if (System.IO.Directory.Exists(filePath) == false)//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            string tempPath = filePath + "\\" + hashKey + "\\";
            //如果不存在就创建file文件夹
            if (!System.IO.Directory.Exists(tempPath))
            {
                System.IO.Directory.CreateDirectory(tempPath);
            }
            string fileUrl = tempPath + fileName;
            string key = "Mall_SD_CARRIER_" + hashKey;
            string redisValue = redisHelper.StringGet(key);
            if (string.IsNullOrEmpty(redisValue))
            {
                redisValue = redisHelper.StringGet(key);
                if (string.IsNullOrEmpty(redisValue))
                {
                    redisHelper.StringSet(key, fileName, TimeSpan.FromMinutes(10));
                    Task.Run(() =>
                    {
                        GetCarrierListToExcel(demodel, ExcelEnumIds, tempPath, fileUrl);
                    });
                }
            }
            return await Task.Run<ApiResult>(() =>
            {
                ApiResult apiResult = new ApiResult()
                {
                    resultCode = 0,
                };
                if (System.IO.File.Exists(fileUrl))
                {
                    var filePath = "/upfile/temporary/" + hashKey + "/";
                    var fileUrl = "/upfile/temporary/" + hashKey + "/" + fileName;
                    apiResult.resultCode = 1;
                    apiResult.data = new { filePath, fileUrl };
                    apiResult.message = key;
                }
                return apiResult;
            });
        }

        /// <summary>
        /// 删除Key
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DeleteKey()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string key = parms.GetStringValue("key");
            string fileUrl = parms.GetStringValue("fileUrl");
            string filepath = parms.GetStringValue("filepath");
            string newPath = Directory.GetCurrentDirectory() + filepath;
            try
            {
                if (Directory.Exists(newPath))
                {
                    Directory.Delete(newPath, true);
                }
                redisHelper.KeyDelete(key);
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "DeleteKey::" + RequestParm.msg.ToString());
            }
            return ApiResult.Success();
        }

        /// <summary>
        /// 文件下载
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public async Task<FileContentResult> GetFile()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string fileUrl = parms.GetStringValue("fileUrl");
            string newPath = Directory.GetCurrentDirectory() + fileUrl;
            if (System.IO.File.Exists(newPath))
            {
                var fileBytes = await System.IO.File.ReadAllBytesAsync(newPath);
                return File(fileBytes, "application/octet-stream");
            }
            else
            {
                return File(Array.Empty<byte>(), "application/octet-stream");
            }
        }

        /// <summary>
        /// 生成品牌文件
        /// </summary>
        /// <param name="demodel">查询参数</param>
        /// <param name="ExcelEnumIds">需要导出的列</param>
        /// <param name="filePath">Logon存放路劲</param>
        /// <param name="excelFileUrl">Excel文件路径</param>
        private async void GetBrandListToExcel(RB_Brand_Extend demodel, List<int> ExcelEnumIds, string filePath, string excelFileUrl)
        {
            try
            {
                demodel.ExcelEnumIds = ExcelEnumIds;
                if (ExcelEnumIds == null || !ExcelEnumIds.Any())
                {
                    demodel.ExcelEnumIds = new List<int>();
                    for (int i = 1; i <= 23; i++)
                    {
                        demodel.ExcelEnumIds.Add(i);
                    }
                }
            }
            catch
            {
                demodel.ExcelEnumIds = new List<int>();
                for (int i = 1; i <= 23; i++)
                {
                    demodel.ExcelEnumIds.Add(i);
                }
            }

            byte[] bytes = null;
            List<ExcelDataSource> slist = new List<ExcelDataSource>();

            var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BusinessExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in demodel.ExcelEnumIds)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }
            slist.Add(header);

            try
            {
                var list = carrierModule.GetBrandListByWhere(demodel);
                List<Action> actions = new List<Action>();
                if (list != null && list.Count > 0)
                {
                    //判断是否下载图片
                    if (demodel.ExcelEnumIds.Contains(4))
                    {
                        foreach (var item in list)
                        {
                            actions.Add(new Action(() =>
                            {
                                DownLoadUrl(item.Logo, filePath);
                            }));
                        }
                    }
                }

                if (actions != null && actions.Count > 0)
                {
                    ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
                    Parallel.Invoke(options, actions.ToArray());
                }

                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in demodel.ExcelEnumIds)
                    {
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ClassName) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.FullBrandName) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Logo, isPic: 1) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandName) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.VideoUrl) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ShopNum.ToString()) { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.BuiltUpArea.ToString()) + "-" + (item.EndBuiltUpArea.ToString())) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.AreaRequirement.ToString()) + "-" + (item.EndAreaRequirement.ToString())) { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CustomerType) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.BrandType) { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.StoreExpansion) { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.ProjectType.HasValue && item.ProjectType.Value > 0) ? item.ProjectType.GetEnumName() : "")) { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.IsShopSize == 1 ? ("有" + (!string.IsNullOrWhiteSpace(item.ShopSize) ? item.ShopSize : "")) : "无")) { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.RanQi == 1 ? ("有" + (!string.IsNullOrWhiteSpace(item.RanQiBZ) ? item.RanQiBZ : "")) : "无")) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.PaiYan == 1 ? ("有" + (!string.IsNullOrWhiteSpace(item.PaiYanBZ) ? item.PaiYanBZ : "")) : "无")) { }); break;
                            case 16:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.IsDianLiang == 1 ? ("有" + (!string.IsNullOrWhiteSpace(item.DianLiang) ? item.DianLiang : "")) : "无")) { }); break;
                            case 17:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Plumbing == 1 ? "有" : "无")) { }); break;
                            case 18:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Caliber == 1 ? ("有") : "无")) { }); break;
                            case 19:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Sewage == 1 ? ("有") : "无")) { }); break;
                            case 20:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.KongTiao == 1 ? ("有") : "无")) { }); break;
                            case 21:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.XinFeng == 1 ? ("有") : "无")) { }); break;
                            case 22:
                                string Advertising = Common.Plugin.StringHelper.AppHtmlFilterr(item.Advertising);
                                datarow.ExcelRows.Add(new ExcelColumn(value: Advertising) { }); break;
                            case 23:
                                string Other = Common.Plugin.StringHelper.AppHtmlFilterr(item.Other);
                                datarow.ExcelRows.Add(new ExcelColumn(value: Other) { }); break;
                        }
                    }
                    slist.Add(datarow);
                }
                #endregion
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
            }
            catch (Exception ex)
            {
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
                LogHelper.Write(ex, string.Format("GetBrandListToExcel_Request: {0}", JsonHelper.Serialize(demodel)));
            }
        }


        /// <summary>
        /// 生成载体文件
        /// </summary>
        /// <param name="demodel">查询参数</param>
        /// <param name="ExcelEnumIds">下载列</param>
        /// <param name="filePath">Logo文件存放路径</param>
        /// <param name="excelFileUrl">Excel文件路径</param>

        private async void GetCarrierListToExcel(RB_Carrier_Extend demodel, List<int> ExcelEnumIds, string filePath, string excelFileUrl)
        {
            byte[] bytes = null;
            try
            {
                demodel.ExcelEnumIds = ExcelEnumIds;
                if (ExcelEnumIds == null || !ExcelEnumIds.Any())
                {
                    demodel.ExcelEnumIds = new List<int>();
                    for (int i = 1; i <= 15; i++)
                    {
                        demodel.ExcelEnumIds.Add(i);
                    }
                }
            }
            catch
            {
                demodel.ExcelEnumIds = new List<int>();
                for (int i = 1; i <= 15; i++)
                {
                    demodel.ExcelEnumIds.Add(i);
                }
            }
            string ExcelName = "载体列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();

            var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.CarrierExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in demodel.ExcelEnumIds)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }

            slist.Add(header);

            try
            {
                var list = carrierModule.GetCarrierList(demodel);
                List<Action> actions = new List<Action>();
                if (list != null && list.Count > 0)
                {
                    //判断是否下载图片
                    if (demodel.ExcelEnumIds.Contains(2))
                    {
                        foreach (var item in list)
                        {
                            actions.Add(new Action(() =>
                            {
                                DownLoadUrl(item.Logo, filePath);
                            }));
                        }
                    }
                }

                if (actions != null && actions.Count > 0)
                {
                    ParallelOptions options = new ParallelOptions { MaxDegreeOfParallelism = 4 };  // 设置最大并行度为 4
                    Parallel.Invoke(options, actions.ToArray());
                }

                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in demodel.ExcelEnumIds)
                    {
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CarrierName) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Logo, isPic: 1) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Developers) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.VideoUrl) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Address) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.OpenTime.HasValue ? item.OpenTime.Value.ToString("yyyy-MM-dd") : "") { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.ProjectType.HasValue && item.ProjectType.Value > 0) ? item.ProjectType.GetEnumName() : "")) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.CarrierSize.ToString()) + "万平方米") { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.LayersNum) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CarNum > 0 ? item.CarNum.ToString() : "") { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CarrierPlan) { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CarrierTarget) { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Location) { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Crowd) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.CarrierMetroList != null && item.CarrierMetroList.Any()) ? (string.Join(",", item.CarrierMetroList.Select(x => x.MetroNum + "号线" + x.MetroName + x.Distance))) : "") { }); break;

                        }
                    }
                    slist.Add(datarow);
                }
                #endregion
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
            }
            catch (Exception ex)
            {
                bytes = ExcelTempLateHelper.ToBrandExcelExtend(slist, filePath);
                using (FileStream fs = new FileStream(excelFileUrl, FileMode.CreateNew))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
                LogHelper.Write(ex, string.Format("GetCarrierListToExcel_Requst: {0}", JsonHelper.Serialize(demodel)));
            }
        }


        /// <summary>
        /// 下载文件
        /// </summary>
        private void DownLoadUrl(string url, string savePath)
        {
            Uri uri = new Uri(url);
            string path = uri.AbsolutePath;
            int lastSlashIndex = path.LastIndexOf('/');
            string fileName = path.Substring(lastSlashIndex + 1);
            string newFilePath = savePath + fileName;
            string logStr = string.Format("{0} 开始下载 Url_{1} 文件 ", DateTime.Now.ToString("MM-dd HH:mm:ss fff"), url);
            try
            {
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.Timeout = 1000 * 60 * 20; // 10分钟超时时间
                using (WebResponse response = request.GetResponse())
                using (Stream responseStream = response.GetResponseStream())
                using (Stream fileStream = new FileStream(newFilePath, FileMode.Create, FileAccess.Write, FileShare.None))
                {
                    responseStream.CopyTo(fileStream);
                }
            }
            catch (Exception ex)
            {
                logStr = string.Format("{0} 下载 Url_{1} 异常:{2}  message:{3}", DateTime.Now.ToString("MM-dd HH:mm:ss fff"), url, ex.StackTrace, ex.Message);
                LogHelper.WriteInfo(logStr);
            }
        }


        /// <summary>
        /// 获取品牌下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBusinessExportEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BusinessExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }
        /// <summary>
        /// 获取品牌大类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBrandCategory()
        {
            var list = Common.Plugin.EnumHelper.EnumToList(typeof(BrandCategoryEnum));
            return ApiResult.Success(data: list);
        }
        #endregion

        #region 榜单管理

        /// <summary>
        /// 获取榜单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopPrizeListPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_FirstShop_List_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_List_Extend>(req.msg.ToString());
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.OrderBy = 1;

            var list = firstShopListModule.GetFirstShopListPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.ListType,
                ListTypeName = x.ListType.GetEnumName(),
                x.ObjectTypeIds,
                x.ObjectTypeList,
                x.Sponsor,
                x.ListName,
                x.CoverImage,
                EndDate = x.EndDate.ToString("yyyy-MM-dd"),
                StartDate = x.StartDate.ToString("yyyy-MM-dd"),
                FinishDate = x.FinishDate.ToString("yyyy-MM-dd HH:mm"),
                x.Content,
                x.EnableRank,
                x.PrizeNum,
                x.ListState,
                ListStateName = x.ListState.GetEnumName(),
                UpdateDate = x.UpdateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取榜单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFistShopPrizeListInfo()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单id
            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = firstShopListModule.GetFirstShopListInfo(ListId);
            if (model == null) { return ApiResult.Failed("榜单不存在"); }
            return ApiResult.Success("", new
            {
                model.Id,
                model.ListType,
                model.ObjectTypeIds,
                model.Sponsor,
                model.ListName,
                model.CoverImage,
                EndDate = model.EndDate.ToString("yyyy-MM-dd"),
                StartDate = model.StartDate.ToString("yyyy-MM-dd"),
                FinishDate = model.FinishDate.ToString("yyyy-MM-dd HH:mm"),
                model.Content,
                model.EnableRank,
                model.PrizeNum,
                model.ListState
            });
        }

        /// <summary>
        /// 设置榜单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetFistShopPrizeListInfo()
        {
            var req = base.RequestParm;
            RB_FirstShop_List_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_List_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Sponsor))
            {
                return ApiResult.ParamIsNull("请输入主办方名称");
            }
            if (string.IsNullOrEmpty(demodel.ListName))
            {
                return ApiResult.ParamIsNull("请输入榜单名称");
            }
            if (string.IsNullOrEmpty(demodel.ObjectTypeIds))
            {
                return ApiResult.ParamIsNull("请选择面向群体");
            }
            if (string.IsNullOrEmpty(demodel.CoverImage))
            {
                return ApiResult.ParamIsNull("请上传封面图");
            }
            if (string.IsNullOrEmpty(demodel.Content))
            {
                return ApiResult.ParamIsNull("请输入详情内容");
            }
            if (demodel.PrizeNum <= 0)
            {
                return ApiResult.ParamIsNull("请输入入围名额");
            }

            demodel.EndDate = Convert.ToDateTime(demodel.EndDate.ToString("yyyy-MM-dd") + " 23:59:59");
            demodel.ListState = Common.Enum.TradePavilion.ListStateEnum.Enroll;
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.Status = 0;
            demodel.CreateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateBy = req.EmpId;
            demodel.UpdateDate = DateTime.Now;

            string msg = firstShopListModule.SetFirstShopListInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 取消榜单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelFistShopPrizeListInfo()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单id
            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            string msg = firstShopListModule.DelFirstShopListInfo(ListId, req.MallBaseId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 获取榜单面向群体枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetListObjectTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ListObjectTypeEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取榜单状态枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetListStateEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ListStateEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取榜单类型枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetListTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ListTypeEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }
        #endregion

        #region 榜单放榜

        /// <summary>
        /// 获取报名列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopEnrollPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_FirstShop_ListEnroll_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_ListEnroll_Extend>(req.msg.ToString());
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;

            var list = firstShopListModule.GetFirstShopEnrollPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.ListId,
                x.UserId,
                x.UserName,
                x.UserIcon,
                x.ObjectType,
                x.ObjectId,
                x.Content,
                x.Reviews,
                x.Rank,
                x.MedalImage,
                x.MedalImageBig,
                x.CandidateState,
                x.RankListState,
                x.CompanyName,
                x.Principal,
                x.Mobile,
                x.ObjectName,
                x.ObjectIcon,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取榜单报名excel导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetFirstShopListEnrollToExcel()
        {

            string ExcelName = "榜单报名" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();

            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单id
            if (ListId <= 0)
            {
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

            try
            {
                List<ExcelDataSource> RList = firstShopListModule.GetFirstShopListEnrollToExcel(ListId, req.MallBaseId);
                slist.AddRange(RList);

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFirstShopListEnrollToExcel: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
        }

        /// <summary>
        /// 获取多榜单excel导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetFirstShopMoreListEnrollToExcel()
        {
            string ExcelName = "多榜单情况" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();

            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string ListIds = parms.GetStringValue("ListIds");//榜单ids
            if (string.IsNullOrEmpty(ListIds))
            {
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

            try
            {
                List<ExcelDataSource> RList = firstShopListModule.GetFirstShopMoreListEnrollToExcel(ListIds, req.MallBaseId);
                slist.AddRange(RList);

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFirstShopMoreListEnrollToExcel: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
        }

        /// <summary>
        /// 报名列表word导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopEnrollWordExport()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int EnrollId = parms.GetInt("EnrollId", 0);
            if (EnrollId <= 0)
            {
                return ApiResult.ParamIsNull("请传递报名id");
            }

            string path = firstShopListModule.GetFirstShopEnrollWordExport(EnrollId, out string errmsg);
            if (errmsg == "")
            {
                return ApiResult.Success("", path);
            }
            else
            {
                return ApiResult.Failed(errmsg);
            }
        }

        /// <summary>
        /// 报名列表word导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopEnrollWordExportBatch()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string EnrollIds = parms.GetStringValue("EnrollIds");//报名ids 英文逗号分隔
            if (string.IsNullOrEmpty(EnrollIds))
            {
                return ApiResult.ParamIsNull("请传递报名ids");
            }
            List<int> EnrollIdList = JsonHelper.DeserializeObject<List<int>>("[" + EnrollIds + "]");

            string path = firstShopListModule.GetFirstShopEnrollWordExport(EnrollIdList, req.MallBaseId);
            return ApiResult.Success("", path);
        }

        /// <summary>
        /// 设置报名状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetFirstShopEnrollState()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int EnrollId = parms.GetInt("EnrollId", 0);//报名Id
            int Type = parms.GetInt("Type", 1);//类型 1淘汰  2候选  3重置

            if (EnrollId <= 0)
            {
                return ApiResult.ParamIsNull("请传递报名ID");
            }

            string msg = firstShopListModule.SetFirstShopEnrollState(EnrollId, Type, req.MallBaseId, req.EmpId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 报名候选列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopEnrollCandidateList()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单Id

            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull("请传递榜单ID");
            }

            var list = firstShopListModule.GetFirstShopEnrollCandidateList(ListId, req.MallBaseId);
            return ApiResult.Success("", list.Select(x => new
            {
                x.Id,
                x.ListId,
                x.UserId,
                x.UserName,
                x.UserIcon,
                x.CompanyName,
                x.ObjectName,
                x.ObjectIcon
            }));
        }

        /// <summary>
        /// 设置放榜
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetFirstShopConfirmListInfo()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int Type = parms.GetInt("Type", 1);//类型 1暂存  2放榜
            int ListId = parms.GetInt("ListId", 0);
            string List = parms.GetStringValue("List");
            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull("请传递榜单id");
            }
            List<RB_FirstShop_ListEnroll_Extend> deList = JsonHelper.DeserializeObject<List<RB_FirstShop_ListEnroll_Extend>>(List);
            if (deList == null || !deList.Any())
            {
                return ApiResult.ParamIsNull("请传递名单列表");
            }
            if (deList.Count() != deList.Select(x => x.Id).Distinct().Count())
            {
                return ApiResult.Failed("有重复数据，请核实后再试");
            }
            foreach (var item in deList)
            {
                if (item.Id <= 0)
                {
                    return ApiResult.ParamIsNull("请传递报名ID");
                }
                if (item.UserId <= 0)
                {
                    return ApiResult.ParamIsNull("请传递用户Id");
                }
                if (string.IsNullOrEmpty(item.Reviews))
                {
                    return ApiResult.ParamIsNull("请输入评语");
                }
                if (string.IsNullOrEmpty(item.MedalImage))
                {
                    return ApiResult.ParamIsNull("请传递奖章");
                }
            }

            string msg = firstShopListModule.SetFirstShopConfirmListInfo(Type, ListId, deList, req.MallBaseId, req.EmpId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 获取榜单上榜列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopConfirmListList()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单Id

            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull("请传递榜单ID");
            }

            var list = firstShopListModule.GetFirstShopConfirmListList(ListId, req.MallBaseId);
            return ApiResult.Success("", list.OrderBy(x => x.Rank).Select(x => new
            {
                x.Id,
                x.ListId,
                x.UserId,
                x.UserName,
                x.UserIcon,
                x.Reviews,
                x.Rank,
                x.MedalImage,
                x.MedalImageBig,
                x.CompanyName,
                x.ObjectName,
                x.ObjectIcon,
            }));
        }




        /// <summary>
        /// 报名列表批量导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetFirstShopEnrollZipExport()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string ListIds = parms.GetStringValue("ListIds");
            if (string.IsNullOrWhiteSpace(ListIds))
            {
                return ApiResult.ParamIsNull("请传递绑定ids");
            }

            string path = firstShopListModule.GetFirstShopEnrollZipExport(ListIds, req.MallBaseId, out string errmsg);
            if (errmsg == "")
            {
                return ApiResult.Success("", path);
            }
            else
            {
                return ApiResult.Failed(errmsg);
            }
        }
        /// <summary>
        /// 报名列表批量导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetFirstShopEnrollZipExport_V3()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string ListIds = parms.GetStringValue("ListIds");
            if (string.IsNullOrWhiteSpace(ListIds))
            {
                return ApiResult.ParamIsNull("请传递绑定ids");
            }

            string path = firstShopListModule.GetPackageFile(ListIds, req.MallBaseId, out string errmsg);
            if (errmsg == "")
            {
                return ApiResult.Success("", path);
            }
            else
            {
                return ApiResult.Failed(errmsg);
            }
        }

        /// <summary>
        /// 报名列表批量导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetNewFirstShopEnrollZipExport()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string ListIds = parms.GetStringValue("ListIds");
            if (string.IsNullOrWhiteSpace(ListIds))
            {
                return ApiResult.ParamIsNull("请传递绑定ids");
            }

            string path = firstShopListModule.GetFirstShopEnrollZipExport_V2(ListIds, req.MallBaseId, out string errmsg);
            if (errmsg == "")
            {
                return ApiResult.Success("", path);
            }
            else
            {
                return ApiResult.Failed(errmsg);
            }
        }
        /// <summary>
        /// 报名列表批量导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult GetFirstShopEnrollResultUrl()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string UserFlag = parms.GetStringValue("UserFlag");
            if (string.IsNullOrWhiteSpace(UserFlag))
            {
                return ApiResult.ParamIsNull("请传递绑定UserFlag");
            }

            string path = firstShopListModule.GetFirstShopEnrollResultUrl(UserFlag, out int errcode);
            if (errcode == 1)
            {
                return ApiResult.Success("", path);
            }
            else
            {
                return ApiResult.Failed("下载请求不存在");
            }
        }

        /// <summary>
        /// 删除生成的zip文件
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 10, Duration = 60)]
        public ApiResult DelFirstShopEnrollZipExport()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            string ListIds = parms.GetStringValue("Url");
            if (string.IsNullOrWhiteSpace(ListIds))
            {
                return ApiResult.ParamIsNull("请传递文件路径");
            }
            firstShopListModule.DelFirstShopEnrollZipExport(ListIds);
            return ApiResult.Success("");
        }

        #endregion

        #region 心愿单列表

        /// <summary>
        /// 获取心愿单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFirstShopWishPageList()
        {
            var requst = RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(requst.msg.ToString());
            RB_FirstShop_Wish_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_Wish_Extend>(requst.msg.ToString());
            demodel.MallBaseId = requst.MallBaseId;
            demodel.TenantId = requst.TenantId;

            var list = firstShopWishModule.GetWishPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, demodel);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                x.UserName,
                x.BranchName,
                x.CarrierName,
                x.Area,
                x.Description,
                x.NameCard,
                x.Status,
                UpdateDate = x.UpdateDate.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 取消心愿单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelFirstShopWishInfo()
        {
            var requst = RequestParm;
            JObject prams = JObject.Parse(requst.msg.ToString());
            int WishId = prams.GetInt("WishId", 0);
            if (WishId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            string msg = firstShopWishModule.DelFirstShopWishInfo(WishId, requst.MallBaseId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 奖项
        /// <summary>
        /// 获取奖项分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetPrizePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Prize_Extend()
            {
                Name = parms.GetStringValue("Name"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetPrizePageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);

            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.BigIco,
                x.SmallIco,
                x.TotalCount,
                x.YearInfo
            });
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取奖项实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetPrizeDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Prize_Extend()
            {
                Id = parms.GetInt("Id", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = carrierModule.GetPrizeList(query).FirstOrDefault();
            if (extModel == null || extModel.Id == 0)
            {
                return ApiResult.Failed("奖项信息不存在");
            }
            return ApiResult.Success(data: extModel);
        }



        /// <summary>
        /// 获取奖项实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetPrizeList()
        {
            var query = new RB_Prize_Extend
            {
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId
            };
            var extList = carrierModule.GetPrizeList(query);
            return ApiResult.Success(data: extList);
        }

        /// <summary>
        /// 新增/修改奖项信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetPrize()
        {
            RB_Prize_Extend query = JsonConvert.DeserializeObject<RB_Prize_Extend>(RequestParm.msg.ToString());
            if (string.IsNullOrWhiteSpace(query.Name))
            {
                return ApiResult.Failed("请输入奖项名称");
            }
            if (string.IsNullOrWhiteSpace(query.BigIco))
            {
                return ApiResult.Failed("请上传大奖章");
            }
            if (string.IsNullOrWhiteSpace(query.SmallIco))
            {
                return ApiResult.Failed("请上传小奖章");
            }

            if (query.Id == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.Status = 0;
            bool flag = carrierModule.SetPrize(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除奖项信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemovePrize()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = carrierModule.RemovePrizeModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        /// <summary>
        /// 获取楼宇分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBuildingCarrierPage()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            ResultPageModel pageModel = new ResultPageModel()
            {
                pageIndex = parms.GetInt("pageIndex"),
                pageSize = parms.GetInt("pageSize"),
            };
            RB_Building_Carrier_Extend query = new RB_Building_Carrier_Extend()
            {
                CarrierName = parms.GetStringValue("CarrierName"),
                CategoryId = parms.GetInt("CategoryId"),
                QStartDate = parms.GetStringValue("QStartDate"),
                QEndDate = parms.GetStringValue("QEndDate"),
                MetroName = parms.GetStringValue("MetroName"),
                MetroNum = parms.GetInt("MetroNum"),
                BuildingCarrierType = parms.GetInt("BuildingCarrierType"),
                OpeningStatus = parms.GetInt("OpeningStatus", -1),
                QShopType = parms.GetInt("QShopType"),
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId,
            };
            List<object> list = new List<object>();
            var dataList = buildingCarrierModule.GetBuildingCarrierPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            foreach (var item in dataList)
            {
                list.Add(new
                {
                    item.ID,
                    item.CarrierName,
                    item.Logo,
                    OpenTime = Common.ConvertHelper.FormatDate(item.OpenTime),
                    item.Address,
                    item.LatAndLon,
                    item.Developers,
                    item.CategoryId,
                    item.CategoryName,
                    item.LayersNum,
                    item.IsChengDu,
                    CreateDate = Common.ConvertHelper.FormatTime(item.CreateDate),
                    CarrierMetroList = item.BuildingCarriermetroList.Select(qitem => new
                    {
                        qitem.MetroNum,
                        qitem.MetroName,
                        qitem.Distance,
                    })
                });
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改楼宇
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBuildingCarrier()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Building_Carrier_Extend extModel = new RB_Building_Carrier_Extend()
            {
                ID = parms.GetInt("ID"),
                CarrierName = parms.GetStringValue("CarrierName"),
                Logo = parms.GetStringValue("Logo"),
                Developers = parms.GetStringValue("Developers"),
                OpeningStatus = parms.GetInt("OpeningStatus"),
                VideoUrl = parms.GetStringValue("VideoUrl"),
                Address = parms.GetStringValue("Address"),
                LatAndLon = parms.GetStringValue("LatAndLon"),
                OpenTime = parms.GetDateTime("OpenTime"),
                BuildingCarrierType = parms.GetInt("BuildingCarrierType"),
                CategoryId = parms.GetInt("CategoryId"),
                Ascription = parms.GetStringValue("Ascription"),
                CarrierSize = parms.GetDecimal("CarrierSize"),
                PropertyComposition = parms.GetStringValue("PropertyComposition"),
                Location = parms.GetStringValue("Location"),
                Crowd = parms.GetStringValue("Crowd"),
                VisitorsFlowrate = parms.GetStringValue("VisitorsFlowrate"),
                LayersNum = parms.GetStringValue("LayersNum"),
                SupportingFacilities = parms.GetStringValue("SupportingFacilities"),
                ManagementCompany = parms.GetStringValue("ManagementCompany"),
                BrandDemand = parms.GetStringValue("BrandDemand"),
            };
            List<string> bannerList = new List<string>();
            string BannerStr = parms.GetStringValue("Banner");
            if (!string.IsNullOrEmpty(BannerStr))
            {
                try
                {
                    bannerList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(BannerStr);
                }
                catch
                {

                }
            }

            extModel.Banner = Common.Plugin.JsonHelper.Serialize(bannerList);
            List<string> HonorList = new List<string>();
            string HonorStr = parms.GetStringValue("Honor");
            if (!string.IsNullOrEmpty(HonorStr))
            {
                try
                {
                    HonorList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(HonorStr);
                }
                catch
                {

                }
            }
            extModel.Honor = Common.Plugin.JsonHelper.Serialize(HonorList);

            string CarrierMetroList = parms.GetStringValue("CarrierMetroList");
            extModel.BuildingCarriermetroList = new List<RB_Building_Carriermetro_Extend>();
            if (!string.IsNullOrEmpty(CarrierMetroList))
            {
                JArray jarray = JArray.Parse(CarrierMetroList);
                if (jarray != null && jarray.Count > 0)
                {
                    foreach (var jItem in jarray)
                    {
                        var sObj = JObject.Parse(jItem.ToString());
                        extModel.BuildingCarriermetroList.Add(new RB_Building_Carriermetro_Extend()
                        {
                            ID = sObj.GetInt("ID"),
                            MetroNum = sObj.GetStringValue("MetroNum"),
                            MetroName = sObj.GetStringValue("MetroName"),
                            Distance = sObj.GetStringValue("Distance"),
                        });
                    }
                }
            }
            if (extModel.ID == 0)
            {
                extModel.CreateBy = RequestParm.TenantId;
                extModel.CreateDate = DateTime.Now;
            }
            else
            {
                extModel.UpdateBy = RequestParm.TenantId;
                extModel.UpdateDate = DateTime.Now;
            }
            extModel.IsChengDu = 0;
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            bool flag = buildingCarrierModule.SetBuildingCarrierModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号获取楼宇信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBuildingCarrierInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int BuildingId = parms.GetInt("ID");
            if (BuildingId <= 0)
            {
                return ApiResult.ParamIsNull(message: "参数不能为空");
            }
            var extModel = buildingCarrierModule.GetBuildingCarrierModule(BuildingId);
            List<string> Banner = new List<string>();
            string BannerStr = extModel?.Banner ?? "";
            if (!string.IsNullOrEmpty(BannerStr))
            {
                try
                {
                    Banner = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(BannerStr);
                }
                catch
                {

                }
            }
            List<string> Honor = new List<string>();
            string HonorStr = extModel?.Honor ?? "";
            if (!string.IsNullOrEmpty(HonorStr))
            {
                try
                {
                    Honor = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(HonorStr);
                }
                catch
                {

                }
            }
            string CategoryName = "";
            if ((extModel?.CategoryId ?? 0) > 0)
            {
                CategoryName = carrierModule.GetBrandClassModule((extModel?.CategoryId ?? 0))?.ClassName ?? "";
            }
            var dataObj = new
            {
                ID = extModel?.ID ?? 0,
                CarrierName = extModel?.CarrierName ?? "",
                Logo = extModel?.Logo ?? "",
                Banner,
                Honor,
                Developers = extModel?.Developers ?? "",
                OpeningStatus = extModel?.OpeningStatus ?? 0,
                VideoUrl = extModel?.VideoUrl ?? "",
                Address = extModel?.Address ?? "",
                LatAndLon = extModel?.LatAndLon ?? "",
                OpenTime = Common.ConvertHelper.FormatDate(extModel?.OpenTime),
                BuildingCarrierType = extModel?.BuildingCarrierType ?? 0,
                CategoryId = extModel?.CategoryId ?? 0,
                CategoryName,
                Ascription = extModel?.Ascription ?? "",
                CarrierSize = extModel?.CarrierSize ?? 0,
                PropertyComposition = extModel?.PropertyComposition ?? "",
                Location = extModel?.Location ?? "",
                Crowd = extModel?.Crowd ?? "",
                VisitorsFlowrate = extModel?.VisitorsFlowrate ?? "",
                LayersNum = extModel?.LayersNum ?? "",
                SupportingFacilities = extModel?.SupportingFacilities ?? "",
                ManagementCompany = extModel?.ManagementCompany ?? "",
                BrandDemand = extModel?.BrandDemand ?? "",
                CarrierMetroList = extModel?.BuildingCarriermetroList ?? new List<RB_Building_Carriermetro_Extend>(),
            };
            return ApiResult.Success(data: dataObj);
        }

        /// <summary>
        /// 根据编号删除楼宇
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveBuildingCarrierInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int ID = parms.GetInt("ID");
            if (ID <= 0)
            {
                return ApiResult.ParamIsNull(message: "参数不能为空");
            }
            var extModel = buildingCarrierModule.RemoveBuildingCarrierModule(ID);
            return ApiResult.Success(data: extModel);
        }
    }
}