﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using Mall.Common.API;
using Mall.Common.Pay.WeChatPat;
using Mall.Common.Plugin;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers.AppletWeChat
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class WeChatNotifyController : BaseController
    {
        private static object _lock = new object();

        /// <summary>
        /// 微信支付方法
        /// </summary>
        /// <param name="sOrderNo"></param>
        /// <param name="sCurOpenID"></param>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult DoPay(string sOrderNo, string sCurOpenID = "")
        {
            if (string.IsNullOrWhiteSpace(sCurOpenID))
            {
                return ApiResult.Failed("OpenId不能为空！");
            }


            string result = "";

            //判断订单信息

            //var model = new REBORN.Module.SellModule.CounponOrderModule().GetEntity(Convert.ToInt32(sOrderNo));
            //if (model == null)
            //{
            //    return ApiResult.Failed("订单信息不存在！");
            //}
            //if (model.OrderState == 2)
            //{
            //    return ApiResult.Failed("订单已支付");
            //}
            //if (model.OrderState == 3)
            //{
            //    return ApiResult.Failed("订单已取消");

            //}
            var payParam = new Common.Pay.WeChatPat.PayParam()
            {
                TotalFee = 1,// Convert.ToInt32(model.PreferPrice * 100),//总价，单位：分。2500即25元
                OpenId = sCurOpenID,//支付用户的OpenId
                OrderNumber = (System.DateTime.Now.ToString("yyyyMMddHHmmssfff")) + sOrderNo,
                ProductName = "测试商品名称", //model.ProductName,
                IsRecharge = false
            };
            try
            {
                LogHelper.Write(null, "DoPay-H5：" + payParam);
                App_Code.PayUtil PayUtil = new App_Code.PayUtil();
                result = PayUtil.CreateJSAPIPayJson(payParam);
                return ApiResult.Success("", result);
            }
            catch (Exception ex)
            {
                if (ex.Message.Contains("timed out"))
                {
                    App_Code.PayUtil PayUtil = new App_Code.PayUtil();
                    var json = PayUtil.CreateJSAPIPayJson(payParam);
                    return ApiResult.Success("", json);
                }
            }
            return ApiResult.Success();
        }


        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string Notify()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify();
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //订单No：dic["sOrderNo"]
                //支付金额：dic["dPrice"]
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];
                    sOrderNo = sOrderNo.Substring(17, 5);
                    // var model = new REBORN.Module.SellModule.CounponOrderModule().GetEntity(Convert.ToInt32(sOrderNo));//获取订单信息

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sTradeNo = dic["sTradeNo"];
                    string sPayerOpenID = dic["sPayerOpenID"];


                     //处理订单信息2020-05-26   逻辑还未处理
                    #region 处理订单信息
                    //if (model.PreferPrice == dPaid)
                    //{

                    //    model.PayType = dic["OrderPayType"].Equals("JSAPI", StringComparison.CurrentCultureIgnoreCase) ? 1 : 2;
                    //    model.sTradeNo = sTradeNo;
                    //    model.sPayerOpenID = sPayerOpenID;
                    //    model.Income = dPaid;
                    //    //查询订单信息
                    //    try
                    //    {

                    //    }
                    //    catch (Exception ex)
                    //    {
                    //        Common.Plugin.LogHelper.Write(ex, string.Format("Notify:infoError"));
                    //    }

                    //    req.SetParameter("return_code", "SUCCESS");
                    //    req.SetParameter("return_msg", "OK");
                    //}
                    //else
                    //{
                    //    req.SetParameter("return_code", "FAIL");
                    //    req.SetParameter("return_msg", "支付金额与订单金额不等");
                    //}
                    #endregion

                }
                var reqXml = req.ParseXml();
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                return reqXml;
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
            }
            //  return ApiResult.Failed();
            //告诉微信我们处理失败，请继续调用我们的接口。好像是会重试8次。

        }
    }
}