﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public  class RB_Reserve_MemberCouponRepository : BaseRepository<RB_Reserve_MemberCoupon>
    {
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_MemberCoupon); } }



        /// <summary>
        /// 会员优惠券
        /// </summary>
        /// <returns></returns>
        public List<RB_Reserve_MemberCoupon_Extend> GetList(RB_Reserve_MemberCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($"   and a.`Status`=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.PlatformType)}={query.PlatformType}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.UserId)}={query.UserId}");
                }
                if (query.CouponId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.CouponId)}={query.CouponId}");
                }
                if (!string.IsNullOrEmpty(query.CouponIds))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.CouponId)} in ({query.CouponIds})");
                }
                if (!string.IsNullOrEmpty(query.Ids))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.Id)} in ({query.Ids})");
                }
                //if (query.UseState >= 0)
                //{
                //    builder.Append($" AND a.{nameof(RB_Member_DiscountCoupon_Extend.UseState)}={query.UseState}");
                //}
            }
            string sql = @$" select * FROM {TableName} AS a  where 1=1 {builder.ToString()} ";
            return Get<RB_Reserve_MemberCoupon_Extend>(sql).ToList();
        }



        /// <summary>
        /// 自动发放优惠券信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_MemberCoupon_Extend> GetAutoMemberCouponPageList(RB_Reserve_MemberCoupon_Extend query)
        {
            string where = "   where a.`Status`=0 ";
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.TenantId)}={query.TenantId}";
                }
                if (query.MallBaseId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.MallBaseId)}={query.MallBaseId}";
                }
                if (query.UserId > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.UserId)}={query.UserId}";
                }
                if (query.GetType > 0)
                {
                    where += $" AND a.{nameof(RB_Reserve_MemberCoupon_Extend.GetType)}={query.GetType}";
                }
            }
            string sql = @$" SELECT a.* from rb_Reserve_membercoupon as a  {where} ";
            return Get<RB_Reserve_MemberCoupon_Extend>(sql).ToList();
        }
    }
}
