﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单明细表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetail_Extend : RB_Goods_OrderDetail
    {
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string CoverImagePath { get; set; }
        /// <summary>
        /// 明细ids
        /// </summary>
        public string OrderDetailIds { get; set; }
        /// <summary>
        /// 是否已发货
        /// </summary>
        public int? IsBindExpress { get; set; }
        /// <summary>
        /// 商品分类ids
        /// </summary>
        public List<int> CategoryIdList { get; set; }
        /// <summary>
        /// 剩余库存
        /// </summary>
        public int InventoryNum { get; set; }
        /// <summary>
        /// 规格价格列表id
        /// </summary>
        public int SpeciPriceId { get; set; }
        /// <summary>
        /// 是否开启单独返佣  1是  2否
        /// </summary>
        public int? SeparateDistribution { get; set; }
        /// <summary>
        /// 分销类型 1普通  2详细
        /// </summary>
        public int? SeparateDistributionType { get; set; }
        /// <summary>
        /// 分销佣金类型  1百分比  2固定值
        /// </summary>
        public int? SeparateDistributionMoneyType { get; set; }

        /// <summary>
        /// 规格列表
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 是否申请售后
        /// </summary>
        public int? IsApplyForAfterSale { get; set; }
    }
}
