﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Order_Extend : RB_Goods_Order
    {
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 是否来自购物车  1是  2否
        /// </summary>
        public int? IsFormShoppingCart { get; set; }
        /// <summary>
        /// 购物车ids
        /// </summary>
        public List<int> ShoppingCartIdList { get; set; }
        /// <summary>
        /// 收货地址id
        /// </summary>
        public int? ShoppingAddressId { get; set; }
        /// <summary>
        /// 商品id
        /// </summary>
        public int? GoodsId { get; set; }
        /// <summary>
        /// 商品订单数量
        /// </summary>
        public int? OrderNum { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 订单对应的总件数
        /// </summary>
        public int GoodsTotalNum { get; set; }

        /// <summary>
        /// 货号
        /// </summary>
        public string ProductCode { get; set; }
        /// <summary>
        /// 订单类型
        /// </summary>
        public int? OrderType { get; set; }
        /// <summary>
        /// 多个状态查询
        /// </summary>
        public string OrderStatusIds { get; set; }
        /// <summary>
        /// 明细列表
        /// </summary>
        public List<RB_Goods_OrderDetail_Extend> DetailList { get; set; }
        /// <summary>
        /// 订单返佣列表
        /// </summary>
        public List<RB_Goods_OrderCommission_Extend> OrderCommissionList { get; set; }
        /// <summary>
        /// 是否发放佣金   1是  2否
        /// </summary>
        public int? IsOrderCommission { get; set; }
        /// <summary>
        /// 导出选项
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 区域地址
        /// </summary>
        public string DistrictAddress { get; set; }
    }
}
