﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序用户中心配置处理类
    /// </summary>
    public class MiniProgramUserCenterConfigModule
    {
        /// <summary>
        /// 小程序用户中心配置仓储层对象
        /// </summary>
        private RB_MiniProgram_UserCenterConfigRepository configRepository = new RB_MiniProgram_UserCenterConfigRepository();

        /// <summary>
        /// 根据查询条件获取小程序用户中心配置实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_UserCenterConfig_Extend GetEntityExtModule(RB_MiniProgram_UserCenterConfig_Extend query)
        {
            var extModel = configRepository.GetEntityExtRepository(query);
            if (extModel == null)
            {
                extModel = new RB_MiniProgram_UserCenterConfig_Extend();
            }
            return extModel;
        }
    }
}
