﻿using VT.FW.DB;
using Mall.Model.Entity.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.Property
{


    /// <summary>
    /// 商品出库记录扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_WarehouseOut_GoodsDetail_Extend : RB_WarehouseOut_GoodsDetail
    {
        /// <summary>
        /// 出库明细ids
        /// </summary>
        public string WarehouseOutIds { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 财务单据id
        /// </summary>
        public int FinanceId { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string WarehouseName { get; set; }

        /// <summary>
        /// 出库数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 出库时间
        /// </summary>
        public DateTime? StockOutDate { get; set; }

        /// <summary>
        /// 重新入库时间
        /// </summary>
        public DateTime? StockInDate { get; set; }

        /// <summary>
        /// 重新入库数量
        /// </summary>
        public int InventoryNum { get; set; }
    }
}
