﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品购物车表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_ShoppingCart_Extend : RB_Goods_ShoppingCart
    {
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 商品状态   1销售中  2下架中  3 失效
        /// </summary>        
        public int? GoodsStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 轮播图  json 格式  第一张为封面图
        /// </summary>        
        public string CarouselImage
        {
            get;
            set;
        }
        /// <summary>
        /// 规格列表
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 售价
        /// </summary>
        public decimal Price { get; set; }
        /// <summary>
        /// 默认规格名称
        /// </summary>
        public string DefaultSpecificationName { get; set; }
        /// <summary>
        /// 是否开启自定义规格
        /// </summary>
        public int? IsCustomSpecification { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }
        /// <summary>
        /// 是否享受会员
        /// </summary>
        public int? EnjoyMember { get; set; }
        /// <summary>
        /// 是否制定会员价格
        /// </summary>
        public int? SeparateSetMember { get; set; }
        /// <summary>
        /// 库存数量
        /// </summary>
        public int? InventoryNum { get; set; }
    }
}
