﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 分类包邮规则
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_FreeShipping
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 单品满件包邮
        /// </summary>        
        public int? FullNumPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满额包邮
        /// </summary>        
        public decimal? FullMoneyPinkage
        {
            get;
            set;
        }

        /// <summary>
        /// 是否启用全局包邮
        /// </summary>

        public int IsEnable { get; set; }
    }
}
