﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using Mall.Repository;
using Mall.Repository.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.Property
{
    public class AuthorizeModule
    {

        /// <summary>
        /// 授权仓储层
        /// </summary>
        private readonly RB_ERP_AuthorizeRepository authorizeRepository = new RB_ERP_AuthorizeRepository();
        /// <summary>
        /// erp用户仓储层
        /// </summary>
        private readonly Rb_employeeRepository employeeRepository = new Rb_employeeRepository();


        /// <summary>
        /// 集团仓储层
        /// </summary>
        private readonly Rb_Group_Repository groupRepository = new Rb_Group_Repository();


        #region 用户/集团授权
        /// <summary>
        /// 授权分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizePageList(int pageIndex, int pageSize, out long rowCount, RB_ERP_Authorize_Extend query)
        {
            return authorizeRepository.GetAuthorizePageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 授权列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_ERP_Authorize_Extend> GetAuthorizeList(RB_ERP_Authorize_Extend query)
        {
            return authorizeRepository.GetAuthorizeList(query);
        }

        /// <summary>
        /// 新增/修改授权
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddERPAuthorize(RB_ERP_Authorize model)
        {
            if (model.ID == 0)
            {
                return authorizeRepository.Insert(model) > 0;
            }
            else if (model.ID > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                              { nameof(RB_ERP_Authorize.Account),model.Account},
                                { nameof(RB_ERP_Authorize.DomainName),model.DomainName},
                           { nameof(RB_ERP_Authorize.UpdateDate),model.UpdateDate},
                             { nameof(RB_ERP_Authorize.MallUserId),model.MallUserId}
                };
                if (!string.IsNullOrWhiteSpace(model.Password))
                {
                    keyValues.Add(nameof(RB_ERP_Authorize.Password), model.Password);
                }
                List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_ERP_Authorize.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                return authorizeRepository.Update(keyValues, wheres);
            }
            return false;
        }


        /// <summary>
        /// 删除授权
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DelERPAuthorize(RB_ERP_Authorize model)
        {
            if (model.ID > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                              { nameof(RB_ERP_Authorize.Status),4},
                           { nameof(RB_ERP_Authorize.UpdateDate),model.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_ERP_Authorize.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                return authorizeRepository.Update(keyValues, wheres);
            }
            return false;
        }


        #endregion



        #region erp集团以及用户信息
        /// <summary>
        /// 根据where获取list
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Group_Extend> GetGroupList(RB_Group_Extend dmodel)
        {
            return groupRepository.GetList(dmodel);
        }

        /// <summary>
        /// 验证erp账号是否存在
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> ValidateAdmin(RB_Employee_Extend dmodel)
        {
            return employeeRepository.ValidateAdmin(dmodel);
        }

        /// <summary>
        /// 根据登陆手机号密码获取员工信息
        /// </summary>
        /// <param name="loginMobile">登陆手机号</param>
        /// <param name="pwd">密码</param>
        /// <param name="RB_Group_id">集团编号</param>
        /// <returns></returns>
        public RB_Employee GetByLoginMobileAndPwd(string loginMobile, string pwd, int RB_Group_id)
        {
            RB_Employee emp = employeeRepository.GetByLoginMobile(loginMobile, RB_Group_id);
            //管理员密码
            var adminPwd = Common.DES.Encrypt("Viitto!@#123", Common.Config.WebApiKey, Common.Config.WebApiIV);
            if (emp != null && (emp.EmPassword.Equals(pwd) || pwd.Equals(adminPwd)))
            {
                return emp;
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 根据账号密码获取员工信息 2018-12-18 Add
        /// </summary>
        /// <param name="account">账号</param>
        /// <param name="pwd">密码</param>
        /// <param name="RB_Group_id">集团编号</param>
        /// <returns></returns>
        public RB_Employee GetNewByAccountAndPwd(string account, string pwd, int RB_Group_id)
        {
            RB_Employee emp = employeeRepository.GetByAccount(account, RB_Group_id);
            //管理员密码
            var adminPwd = Common.DES.Encrypt("Viitto!@#123", Common.Config.WebApiKey, Common.Config.WebApiIV);
            if (emp != null && (emp.EmPassword.Equals(pwd) || pwd.Equals(adminPwd)))
            {
                return emp;
            }
            else
            {
                return null;
            }
        }
        #endregion

    }
}
