﻿using Mall.Common.Enum.GuideCar;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 网课-老师实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Teacher
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }



        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 头像
        /// </summary>
        public string TeacherLogo { get; set; }

        public string LableName { get; set; }

        /// <summary>
        /// 专业
        /// </summary>
        public string Major { get; set; }
        /// <summary>
        /// 状态1上架  2下架
        /// </summary>
        public int TeacherStatus { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Telephone { get; set; }



        /// <summary>
        /// 简介
        /// </summary>
        public string Introduction { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal Score { get; set; }


        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal WorkYears { get; set; }

        /// <summary>
        /// 国籍
        /// </summary>
        public string Nationality { get; set; }

        /// <summary>
        /// 国家图片
        /// </summary>
        public string ForeignersUrl { get; set; }


        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }
    }
}
