﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品评论表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Comment_Extend : RB_Goods_Comment
    {
        /// <summary>
        /// 商品图片
        /// </summary>
        public string CarouselImage { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }
        /// <summary>
        /// 评论图片列表
        /// </summary>
        public List<string> CommentImgList { get; set; }
        /// <summary>
        /// 头像路径
        /// </summary>
        public string UserPhotoPath { get; set; }
        /// <summary>
        /// 评论数量
        /// </summary>
        public int CommentNum { get; set; }



        /// <summary>
        /// 评论总分
        /// </summary>
        public decimal TotalScore { get; set; }


        #region 司导信息
       
        /// <summary>
        /// 导游名称
        /// </summary>
        public string GuideName { get; set; }

        /// <summary>
        /// 车辆名称
        /// </summary>
        public string CarName { get; set; }
        /// <summary>
        /// 车辆颜色
        /// </summary>
        public string CarColorName { get; set; }

        /// <summary>
        /// 车辆品牌
        /// </summary>
        public string CarBrandName { get; set; }


        #endregion
    }




    /// <summary>
    /// 司导商品评论扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class GoodsComment_Extend
    {
        /// <summary>
        /// 评论总分
        /// </summary>
        public decimal TotalScore { get; set; }

        public int OrderDetailId { get; set; }

        public int GoodsId { get; set; }

        public string UpdateDate { get; set; }

        public int UserId { get; set; }
        public int UserPhoto { get; set; }

        public int Is_Anonymity { get; set; }

        public string UserName { get; set; }
        public string UserPhotoPath { get; set; }

        public int CommentGrade { get; set; }
        /// <summary>
        /// 评价
        /// </summary>
        public List<RB_Goods_Comment_Extend> CommentList { get; set; }
    }
}
