﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Test.Model
{
    /// <summary>
    /// 订单信息
    /// </summary>
    public class OrderInfo
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int user_id { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string order_no { get; set; }
        /// <summary>
        /// 订单总金额
        /// </summary>
        public decimal total_price { get; set; }
        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal total_pay_price { get; set; }

        public decimal express_original_price { get; set; }

        public decimal express_price { get; set; }

        public decimal total_goods_price { get; set; }

        public decimal total_goods_original_price { get; set; }

        public decimal member_discount_price { get; set; }

        public int use_user_coupon_id { get; set; }

        public decimal coupon_discount_price { get; set; }

        public int use_integral_num { get; set; }

        public decimal integral_deduction_price { get; set; }

        public string name { get; set; }

        public string mobile { get; set; }

        /// <summary>
        /// 收货地址
        /// </summary>
        public string address { get; set; }

        public string remark { get; set; }

        public string seller_remark { get; set; }
        public int is_pay { get; set; }
        public string pay_time { get; set; }
        public int is_send { get; set; }
        public string send_time { get; set; }
        public int is_confirm { get; set; }
        public string confirm_time { get; set; }

        public string comment_time { get; set; }

        public string cancel_time { get; set; }

        public string created_at { get; set; }
        /// <summary>
        /// 取消状态  =1 表示取消
        /// </summary>
        public int cancel_status { get; set; }
        /// <summary>
        /// 是否回收站  1是  0否
        /// </summary>
        public int is_recycle { get; set; }

        public int is_delete { get; set; }

        public List<OrderDetailInfo> detail { get; set; }

        public List<DetailExpress> detailExpress { get; set; }

        public string PName { get; set; }
        public string CName { get; set; }
        public string DName { get; set; }
    }

    public class OrderDetailInfo{
        public int id { get; set; }

        public int order_id { get; set; }

        public int goods_id { get; set; }

        public decimal unit_price { get; set; }

        public decimal total_original_price { get; set; }

        public decimal total_price { get; set; }

        public decimal member_discount_price { get; set; }

        public string created_at { get; set; }

        public string goods_no { get; set; }

        public GoodsInfo goods_info { get; set; }

        public ExpressRelation expressRelation { get; set; }
    }

    public class ExpressRelation { 
        public int id { get; set; }
        public int order_id { get; set; }
        public int order_detail_id { get; set; }
        public int order_detail_express_id { get; set; }
        public int is_delete { get; set; }
    }

    public class GoodsInfo { 
        public List<GoodsAttrList> attr_list { get; set; }

        public GoodsAttr goods_attr { get; set; }
    }

    public class GoodsAttrList { 
        public string attr_group_name { get; set; }
        public int attr_group_id { get; set; }
        public int attr_id { get; set; }
        public string attr_name { get; set; }
    }

    public class GoodsAttr { 
        public int id { get; set; }
        public int goods_id { get; set; }
        public string sign_id { get; set; }
        public string name { get; set; }
        public string cover_pic { get; set; }
        public string no { get; set; }
        public int weight { get; set; }
        public int number { get; set; }
    }

    public class DetailExpress { 
        public int id { get; set; }
        public int order_id { get; set; }
        public string express { get; set; }
        public int send_type { get; set; }
        public string express_no { get; set; }
        /// <summary>
        /// send_type=2
        /// </summary>
        public string express_content { get; set; }
        public int is_delete { get; set; }
        public string created_at { get; set; }
    }

    public class ExpressInfo { 
        public int id { get; set; }
        public string name { get; set; }
        public string code { get; set; }
    }
}
