﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers.CAP
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TestController : BaseController
    {
        private readonly DotNetCore.CAP.ICapPublisher _capBus;
        public TestController(DotNetCore.CAP.ICapPublisher capPublisher)
        {
            this._capBus = capPublisher;
        }

        [HttpPost]
        [AllowAnonymous]
        public ApiResult Get()
        {
            ApiResult apiResult = new ApiResult()
            {
                message = "操作成功",
                resultCode = 1,
                data = DateTime.Now
            };
            _capBus.Publish("show.time", Common.Plugin.JsonHelper.Serialize(apiResult));
          
            return apiResult;
        }

        [NonAction]
        [AllowAnonymous]
        [DotNetCore.CAP.CapSubscribe("show.time")]
        public void CheckReceiveMessage(string result)
        {
            string str = "";
            
            Console.WriteLine(result);
        }
    }
}