﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 素材管理表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Material_Info
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 素材名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1图片  2视频  3其他word,pdf,ppf
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 分组ID  0表示全部
        /// </summary>        
        public int? GroupId
        {
            get;
            set;
        }
        /// <summary>
        /// 存放路径
        /// </summary>        
        public string Path
        {
            get;
            set;
        }
        /// <summary>
        /// 视频封面图
        /// </summary>        
        public string Image
        {
            get;
            set;
        }
        /// <summary>
        /// 视频时长  秒
        /// </summary>        
        public int? VideoTime
        {
            get;
            set;
        }
        /// <summary>
        /// 视频的宽高
        /// </summary>        
        public string WithHeight
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 回收  1正常  2回收
        /// </summary>
        public int? Recycled { get; set; }
        /// <summary>
        /// 删除状态
        /// </summary>
        public int? Status { get; set; }

        /// <summary>
        /// 文件存储  1腾讯  2阿里
        /// </summary>
        public int? PathType { get; set; }
    }
}
