﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;
using Mall.Model.Entity.TradePavilion;

namespace Mall.Model.Extend.TradePavilion
{
    public class RB_Carrier_Extend : RB_Carrier
    {
        /// <summary>
        /// 地铁信息
        /// </summary>
        public List<RB_CarrierMetro_Extend> CarrierMetroList { get; set; }


        /// <summary>
        /// 载体荣誉图
        /// </summary>
        public List<string> HonorList { get; set; }

        /// <summary>
        /// 载体ids查询
        /// </summary>
        public string CarrierIds { get; set; }

        /// <summary>
        /// 介绍图
        /// </summary>
        public List<string> BannerList { get; set; }

        /// <summary>
        /// 排序(1-创建时间倒序，2-开业时间倒序)
        /// </summary>
        public int OrderBy { get; set; }

        /// <summary>
        /// 开业时间
        /// </summary>
        public string StartOpenTime { get; set; }
        /// <summary>
        /// 开业时间
        /// </summary>
        public string EndOpenTime { get; set; }
        /// <summary>
        /// 地铁线路
        /// </summary>
        public int MetroNum { get; set; }


        /// <summary>
        /// 站点名称
        /// </summary>
        public string MetroName { get; set; }

        /// <summary>
        /// 收藏id
        /// </summary>
        public int CollectId { get; set; }

        /// <summary>
        /// 导出选中的字段
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }

        /// <summary>
        /// 认证用户
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 认证用户头像
        /// </summary>
        public string UserIcon { get; set; }

        /// <summary>
        /// 查询多少条数据
        /// </summary>
        public int QTop { get; set; }

        /// 载体ids
        /// </summary>
        public string QCarrierIds { get; set; }


        public List<FirstShopNumModel> FirstShopNumList { get; set; }


        /// <summary>
        /// 奖章
        /// </summary>
        public List<RB_FirstShop_ListEnroll_Extend> ListEnroll { get; set; }
    }

    /// <summary>
    /// 首店数量
    /// </summary>
    public class FirstShopNumModel
    {

        /// <summary>
        /// 类型
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int Num { get; set; }


        public string Name { get; set; }
    }
}
