﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 活动仓储层
    /// </summary>
    public class RB_Miai_ActivityRepository : BaseRepository<RB_Miai_Activity>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_Activity_Extend dmodel)
        {
            string where = $" 1=1 and a.{nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle))
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Id)} ={dmodel.Id}";
            }
            if (dmodel.IsSelectEnroll == 1)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Deadline)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }
            string orderBy = " a.Id DESC";
            if (dmodel.OrderBy == 1)
            {
                orderBy = " a.CreateDate DESC";
            }
            string sql = $@"select a.*,u.Name as UserName,u.Photo,b.Sex,IFNULL(d.DianZanNum,0) as DianZanNum from RB_Miai_Activity a
left join rb_member_user u on a.UserId =u.Id
left join rb_miai_baseinfo b on a.UserId =b.UserId
LEFT JOIN (SELECT ActivityId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId=0  GROUP BY ActivityId) as d on d.ActivityId=a.Id
where {where} order by {orderBy}";
            return GetPage<RB_Miai_Activity_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetPageList_V2(int pageIndex, int pageSize, out long rowCount, RB_Miai_Activity_Extend dmodel)
        {
            string where = $" 1=1 and a.{nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle))
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.IsSelectEnroll == 1)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Deadline)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }
            string orderBy = " a.Id DESC";
            if (dmodel.OrderBy == 1)
            {
                orderBy = " e.Number DESC,a.Id DESC";
            }
            else if (dmodel.OrderBy == 2)
            {
                orderBy = " r.ReplyNum DESC,a.Id DESC";
            }

            string sql = $@"select a.*,u.Name as UserName,u.Photo,b.Sex,IFNULL(r.ReplyNum,0) as ReplyNum,IFNULL(e.Number,0) as EnrollNum
from RB_Miai_Activity a
left join rb_member_user u on a.UserId =u.Id
left join rb_miai_baseinfo b on a.UserId =b.UserId
left join (select ActivityId,count(0) as ReplyNum from RB_Miai_ActivityDiscuss where Status =0 group by ActivityId) r on r.ActivityId = a.Id
left join (select ActivityId,count(0) as Number from RB_Miai_ActivityEnroll where Status =0 group by ActivityId) e on e.ActivityId = a.Id
where {where} order by {orderBy}";
            return GetPage<RB_Miai_Activity_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetList(RB_Miai_Activity_Extend dmodel, bool IsAll = false)
        {
            string where = $" 1=1 and a.{nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (IsAll) { where = " 1=1"; }
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityIds))
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Id)} in({dmodel.ActivityIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle))
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.UserId)} ={dmodel.UserId}";
            }

            string orderBy = " a.Id DESC";
            if (dmodel.OrderBy == 1)
            {
                orderBy = " a.CreateDate DESC";
            }
            string sql = $@"select a.*,u.Name as UserName,u.Photo,b.Sex,IFNULL(d.DianZanNum,0) as DianZanNum from RB_Miai_Activity a
left join rb_member_user u on a.UserId =u.Id
left join rb_miai_baseinfo b on a.UserId =b.UserId
LEFT JOIN (SELECT ActivityId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId=0  GROUP BY ActivityId) as d on d.ActivityId=a.Id
where {where} order by {orderBy}";
            return Get<RB_Miai_Activity_Extend>(sql).ToList();
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Activity_Extend> GetPageList_V3(int pageIndex, int pageSize, out long rowCount, RB_Miai_Activity_Extend dmodel)
        {
            string where = $" 1=1 and a.{nameof(RB_Miai_Activity_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityTitle))
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ActivityTitle)} like '%{dmodel.ActivityTitle}%'";
            }
            if (dmodel.ForumId > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.ForumId)} ={dmodel.ForumId}";
            }
            if (dmodel.IsFollow == 1)
            {
                if (dmodel.UserId > 0)
                {
                    where += $@" and f.CreateBy ={dmodel.UserId}";
                }
            }
            if (dmodel.Id > 0)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Id)} ={dmodel.Id}";
            }
            if (dmodel.IsSelectEnroll == 1)
            {
                where += $@" and a.{nameof(RB_Miai_Activity_Extend.Deadline)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }
            string orderBy = " a.Id DESC";
            if (dmodel.OrderBy == 1)
            {
                orderBy = " a.CreateDate DESC";
            }
            string sql = $@"select a.*,u.Name as UserName,u.Photo,b.Sex,IFNULL(d.DianZanNum,0) as DianZanNum from RB_Miai_Activity a
left join rb_member_user u on a.UserId =u.Id
left join rb_miai_baseinfo b on a.UserId =b.UserId
LEFT JOIN rb_miai_followmember  f on f.UserId=a.UserId
LEFT JOIN (SELECT ActivityId,COUNT(*) DianZanNum from rb_miai_dianzan where `Status`=0 and ActivityId>0 and ActivityDiscussId=0  GROUP BY ActivityId) as d on d.ActivityId=a.Id
where {where} order by {orderBy}";
            return GetPage<RB_Miai_Activity_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }
    }
}
