﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 物料有效期仓储类
    /// </summary>
    public partial class RB_Supplies_StockInValidityRepository : BaseRepository<RB_Supplies_StockInValidity>
    {
        /// <summary>
        /// 获取分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_StockInValidity_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_StockInValidity_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_StockInValidity_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.StockinId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockinId) + $" ={dmodel.StockinId}";
            }
            if (dmodel.StockinDetailId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockinDetailId) + $" ={dmodel.StockinDetailId}";
            }
            if (dmodel.IsOut > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.IsOut) + $" ={dmodel.IsOut}";
            }
            if (dmodel.StockoutId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockoutId) + $" ={dmodel.StockoutId}";
            }

            string sql = $@" select * from RB_Supplies_StockInValidity {where} order by Id desc";            
            return GetPage<RB_Supplies_StockInValidity_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_StockInValidity_Extend> GetList(RB_Supplies_StockInValidity_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_StockInValidity_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (!string.IsNullOrEmpty(dmodel.ValidityIds))
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.Id) + $" in({dmodel.ValidityIds})";
            }
            if (dmodel.StockinId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockinId) + $" ={dmodel.StockinId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StockInIdStr))
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockinId) + $" in({dmodel.StockInIdStr})";
            }
            if (dmodel.StockinDetailId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockinDetailId) + $" ={dmodel.StockinDetailId}";
            }
            if (dmodel.IsOut > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.IsOut) + $" ={dmodel.IsOut}";
            }
            if (dmodel.StockoutId > 0)
            {
                where += " and " + nameof(RB_Supplies_StockInValidity_Extend.StockoutId) + $" ={dmodel.StockoutId}";
            }

            string sql = $@" select * from RB_Supplies_StockInValidity {where} order by Id desc";
            return Get<RB_Supplies_StockInValidity_Extend>(sql).ToList();            
        }
    }
}
