﻿using Mall.Common.AOP;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单明细表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetail
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 订单id
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单类型  枚举
        /// </summary>        
        public OrderTypeEnum? OrderType
        {
            get;
            set;
        }
        /// <summary>
        /// 商品名称
        /// </summary>        
        public string GoodsName
        {
            get;
            set;
        }
        /// <summary>
        /// 封面图
        /// </summary>        
        public int? CoverImage
        {
            get;
            set;
        }
        /// <summary>
        /// 规格
        /// </summary>        
        public string Specification
        {
            get;
            set;
        }
        /// <summary>
        /// 规格key
        /// </summary>
        public string SpecificationSort { get; set; }
        /// <summary>
        /// 货号
        /// </summary>        
        public string ProductCode
        {
            get;
            set;
        }
        /// <summary>
        /// 单价
        /// </summary>        
        public decimal? Unit_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }
        /// <summary>
        /// 原价 (=单价*数量)
        /// </summary>        
        public decimal? Original_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 最终价格
        /// </summary>        
        public decimal? Final_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 折扣
        /// </summary>        
        public decimal? DiscountRate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否商品单独会员价购买  1是  2否
        /// </summary>        
        public int? IsMemberPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 成本价
        /// </summary>
        public decimal? CostMoney { get; set; }
        /// <summary>
        /// 是否评论   1是  2否
        /// </summary>
        public int? IsComment { get; set; }
        /// <summary>
        /// 运费
        /// </summary>
        public decimal? FreightMoney { get; set; }



    }
}
