﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;


namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]

    public class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            var homePage = new object();
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetHomeData: true);
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                {
                    MallBaseId = miniProgram.MallBaseId,
                    TenantId = miniProgram.TenantId,
                }, isGetHome: true);
                List<object> list = new List<object>();
                //自定义首页
                if (selfHomePage != null && selfHomePage.Id > 0)
                {
                    //获取模板编号
                    string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                    var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                        QIds = templateIds
                    }, IsAnalyzePlus: true);
                    //解析模板
                    foreach (var item in templateList)
                    {
                        var detailsModel = selfHomePage?.DetailsList?.Where(qitem => qitem.TemplateId == item.Id)?.FirstOrDefault();
                        var templateData = new
                        {
                            id = detailsModel?.Id ?? 0,
                            name = detailsModel?.NavName ?? "",
                            data = new List<object>()
                        };
                        if (item.ComponentDataList != null && item.ComponentDataList.Count() > 0)
                        {
                            foreach (var subItem in item.ComponentDataList)
                            {
                                templateData.data.Add(PlusDataToObject(subItem));
                            }
                        }

                        var tempObj = new
                        {
                            id = item.Id,
                            name = item.TemplateName,
                            page_id = 0,
                            template_id = item.Id,
                            template = templateData
                        };
                        list.Add(tempObj);
                    }

                    homePage = new
                    {
                        id = miniProgram.MallBaseId,
                        title = miniProgram.MallName,
                        show_navs = selfHomePage.IsShowNav,
                        is_home_page = selfHomePage.IsHome,
                        navs = list
                    };
                }
                //默认首页
                else
                {
                    //配置了首页
                    if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                    {
                        var templateData = new
                        {
                            id =   0,
                            name =  "",
                            data = new List<object>()
                        };
                        foreach (var subitem in miniProgram.HomeDataList)
                        {
                            switch (subitem.key)
                            {
                                //搜索框
                                case "search":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.imgBg
                                    });
                                    break;

                                //轮播图
                                case "banner":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.row_num,
                                        subitem.imgBg
                                    });
                                    break;
                                //导航图标
                                case "home_nav":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.row_num,
                                        subitem.imgBg
                                    });
                                    break;
                                //视频
                                case "video":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.video_url,
                                        subitem.video_pic_url,
                                        subitem.imgBg
                                    });
                                    break;

                                //公告
                                case "notice":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.notice_url,
                                        subitem.notice_bg_color,
                                        subitem.notice_text_color,
                                        subitem.imgBg
                                    });
                                    break;
                                //专题
                                case "topic":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.topic_num,
                                        subitem.topic_url,
                                        subitem.topic_url_2,
                                        subitem.label_url,
                                        subitem.imgBg
                                    });
                                    break;

                                //领券中心
                                case "coupon":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.coupon_url,
                                        subitem.coupon_not_url,
                                        subitem.imgBg
                                    });
                                    break;
                                //所有分类
                                case "cat":

                                    break;
                                //图片魔方
                                case "block":

                                    break;
                                //预约
                                case "booking":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.imgBg
                                    });
                                    break;
                                //拼团
                                case "pintuan":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.imgBg
                                    });
                                    break;
                                //预售
                                case "advance":
                                    templateData.data.Add(new
                                    {
                                        subitem.key,
                                        subitem.name,
                                        subitem.relation_id,
                                        subitem.is_edit,
                                        subitem.imgBg
                                    });
                                    break;
                            }
                        }

                        homePage = new
                        {
                            id = 0,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };
                    }
                    //未配置自定义页面
                    else
                    {
                        homePage = new
                        {
                            id = -1,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };

                    }
                }
            }
            var objResult = new {
                home_pages = homePage
            };
            return ApiResult.Success(data: objResult);
        }

        /// <summary>
        /// 解析插件数据为对象
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public object PlusDataToObject(ComponentItem subItem)
        {
            var obj = new object();
            switch (subItem.Id)
            {
                //背景插件
                case "background":
                    var backgroundData = subItem.data as backgroundItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = backgroundData
                    };
                    break;
                //搜索插件
                case "search":
                    var searchData = subItem.data as searchItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = searchData
                    };
                    break;
                //导航组件
                case "nav":
                    var navData = subItem.data as navItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = navData
                    };
                    break;
                //轮播广告插件
                case "banner":
                    var bannerData = subItem.data as bannerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bannerData
                    };
                    break;
                //公告组件
                case "notice":
                    var noticeData = subItem.data as noticeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = noticeData
                    };
                    break;
                //专题组件
                case "topic":
                    var topicData = subItem.data as topicItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = topicData
                    };
                    break;
                //标题组件
                case "link":
                    var linkData = subItem.data as linkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = linkData
                    };
                    break;
                //图片广告插件
                case "rubik":
                    var rubikData = subItem.data as rubikItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = rubikData
                    };
                    break;
                //视频插件
                case "video":
                    var videoData = subItem.data as videoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = videoData
                    };
                    break;
                //商品插件
                case "goods":
                    var goodsData = subItem.data as goodsItem;
                    if (goodsData != null)
                    {
                        if (goodsData.list != null && goodsData.list.Count > 0)
                        {
                            foreach (var childItem in goodsData.list)
                            {
                                childItem.picUrl = Common.Config.GetFileUrl(childItem.picUrl);
                            }
                        }
                        if (goodsData.catList != null && goodsData.catList.Count > 0)
                        {
                            foreach (var childItem in goodsData.catList)
                            {
                                if (childItem.goodsList != null && childItem.goodsList.Count > 0)
                                {
                                    foreach (var lastItem in childItem.goodsList)
                                    {
                                        lastItem.picUrl = Common.Config.GetFileUrl(lastItem.picUrl);
                                    }
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = goodsData
                    };
                    break;
                //门店插件
                case "store":
                    var storeData = subItem.data as storeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = storeData
                    };
                    break;
                //版权插件
                case "copyright":
                    var copyrightData = subItem.data as copyrightItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = copyrightData
                    };
                    break;
                //签到插件
                case "check-in":
                    var checkinData = subItem.data as checkinItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = checkinData
                    };
                    break;
                //用户信息插件
                case "user-info":
                    var userinfoData = subItem.data as userinfoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userinfoData
                    };
                    break;
                //用户订单插件
                case "user-order":
                    var userorderData = subItem.data as userorderItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userorderData
                    };
                    break;
                //地图插件
                case "map":
                    var mapData = subItem.data as mapItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mapData
                    };
                    break;
                //微信公众号插件
                case "mp-link":
                    var mplinkData = subItem.data as mplinkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mplinkData
                    };
                    break;
                //图文插件
                case "image-text":
                    var imagetextData = subItem.data as imagetextItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = imagetextData
                    };
                    break;
                //优惠券插件
                case "coupon":
                    var couponData = subItem.data as couponItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = couponData
                    };
                    break;
                //倒计时插件
                case "timer":
                    var timerData = subItem.data as timerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = timerData
                    };
                    break;
                //拼团插件
                case "pintuan":
                    var pintuanData = subItem.data as pintuanItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = pintuanData
                    };
                    break;
                //预约插件
                case "booking":
                    var bookingData = subItem.data as bookingItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bookingData
                    };
                    break;
                //砍价插件
                case "bargain":
                    var bargainData = subItem.data as bargainItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bargainData
                    };
                    break;
                //积分商城插件
                case "integral-mall":
                    var integralmallData = subItem.data as integralmallItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = integralmallData
                    };
                    break;
                //抽奖插件
                case "lottery":
                    var lotteryData = subItem.data as lotteryItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = lotteryData
                    };
                    break;

                //预售
                case "advance":
                    var advanceData = subItem.data as advanceItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = advanceData
                    };
                    break;

                //超级会员卡
                case "vip-card":
                    var vipcardData = subItem.data as vipcardItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = vipcardData
                    };
                    break;
                //直播组件
                case "live":
                    var liveData = subItem.data as liveItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = liveData
                    };
                    break;


                //空组件
                case "empty":
                    var emptyData = subItem.data as emptyItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = emptyData
                    };
                    break;

                //流量主广告
                case "ad":
                    var adData = subItem.data as adItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = adData
                    };
                    break;

                //弹窗广告
                case "modal":
                    var modalData = subItem.data as modalItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = modalData
                    };
                    break;

                //弹窗广告
                case "quick-nav":
                    var quicknavData = subItem.data as quicknavItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = quicknavData
                    };
                    break;
            }
            return obj;
        }


        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetUserCenter()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var mall = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var config = new
                {
                    //顶部导航
                    title_bar = new
                    {
                        //顶部背景颜色
                        background = miniProgram.TopNavBgColor,
                        //顶部文字颜色
                        color = miniProgram.TopNavWordColor,
                    },
                    //用户中心
                    user_center = new
                    {
                        //是否显示账户栏
                        is_account_status = (miniProgram.IsShowAccountNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_menu_status = (miniProgram.IsShowMenuNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_order_bar_status = (miniProgram.IsShowOrderNav == 0 ? 1 : 0),
                        //是否显示收藏夹
                        is_foot_bar_status = (miniProgram.IsShowFavorite == 0 ? 1 : 0),
                        //菜单样式
                        menu_style = (miniProgram.MenuNavStyle == 0 ? 1 : 2),
                        //头像样式
                        top_style = (miniProgram.HeadStyle),
                        //顶部默认背景图
                        top_pic_url = miniProgram.DefaultBgImg,
                        //普通用户背景图
                        member_pic_url = miniProgram.MemberBgImg,
                        //会员中心背景图
                        member_bg_pic_url = miniProgram.VipBgImg,
                        //头像内嵌背景图[暂无]
                        style_bg_pic_url = "",

                        //账户相关菜单
                        account = miniProgram?.AccountMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            is_show = 1,
                        }),
                        //自定义菜单
                        menus = miniProgram?.SelfMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            @params = "",

                        }),
                        //订单菜单列表
                        order_bar = miniProgram?.OrderMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            text = "",
                        }),
                        //收藏足迹
                        foot_bar = miniProgram?.FavoriteFootMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                        }),
                        //版权设置
                        copyright = new
                        {
                            pic_url = miniProgram.CopyRightImg,
                            description = miniProgram.CopyRightWord,
                            link_url = miniProgram.CopyRightLink,
                        }
                    }
                };
                mall = new
                {
                    id = miniProgram.MallBaseId,
                    name = miniProgram.MallName,
                    //配置信息
                    config
                };
            }
            return ApiResult.Success(data: mall);
        }
    }
}