﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户会员等级表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_Grade
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 等级
        /// </summary>        
        public int? Grade
        {
            get;
            set;
        }
        /// <summary>
        /// 等级名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 折扣率
        /// </summary>        
        public decimal? Discount
        {
            get;
            set;
        }
        /// <summary>
        /// 启用  1是  2否
        /// </summary>
        public int? Enabled { get; set; }

        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 会员图标
        /// </summary>        
        public int? Icon
        {
            get;
            set;
        }
        /// <summary>
        /// 会员背景图片
        /// </summary>        
        public int? BackgroundImage
        {
            get;
            set;
        }
        /// <summary>
        /// 自动升级  1是  2否
        /// </summary>        
        public int? IsAutoUpGrade
        {
            get;
            set;
        }
        /// <summary>
        /// 累计完成订单金额 自动升级
        /// </summary>        
        public decimal? UpGradeMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 会员是否可购买  1是  2否
        /// </summary>        
        public int? IsMemberBuy
        {
            get;
            set;
        }
        /// <summary>
        /// 会员购买价格
        /// </summary>        
        public decimal? MemberBuyMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 会员规则
        /// </summary>        
        public string MemberSpecification
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 更新时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
    }
}
