﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    public class RB_Education_TeacherRepository : BaseRepository<RB_Education_Teacher>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_Teacher); } }
        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Teacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Education_Teacher_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Telephone))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Telephone)} like '%{query.Telephone}%'");
                }
                if (query.TeacherStatus > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TeacherStatus)}={query.TeacherStatus}");
                }
            }
            return GetPage<RB_Education_Teacher_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherList(RB_Education_Teacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Education_Teacher_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Telephone))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Telephone)} like '%{query.Telephone}%'");
                }
                if (query.TeacherStatus > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TeacherStatus)}={query.TeacherStatus}");
                }
            }
            return Get<RB_Education_Teacher_Extend>(builder.ToString()).ToList();
        }
    }
}
