﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;
using Mall.AOP;
using Mall.Model.Extend.GuideCar;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class GuideCarController : BaseController
    {

        private readonly GuideCarModule guideCarModule = new GuideCarModule();

        #region 基础配置
        /// <summary>
        /// 获取司导专区基础配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarInfo()
        {
            var req = RequestParm;

            var model = guideCarModule.GetGuideCarInfo(req.TenantId, req.MallBaseId);

            return ApiResult.Success();
        }

        #endregion



        #region 站点配置
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarSiteList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_Site_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.SiteType = 1;
            var list = guideCarModule.GetGuideCarSiteList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.SiteName,
                x.IsEnable,
                RegionList = x.RegionList.Select(x => x.RegionName)
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 删除站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelGuideCarSiteInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = guideCarModule.DelGuideCarSiteInfo(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }


        /// <summary>
        /// 删除站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult EnableGuideCarSiteInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            string idInfo = parmsJob.GetStringValue("Ids");
            int isEnable = parmsJob.GetInt("IsEnable", 0);
            if (string.IsNullOrWhiteSpace(idInfo))
            {
                return ApiResult.Failed("请传递参数");
            }

            bool flag = guideCarModule.EnableGuideCarSiteInfo(idInfo.Split(",").ToList(), isEnable, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarSiteModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            var oldLogisticsModel = guideCarModule.GetGuideCarSiteModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Site_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 获取全部站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAllGuideCarSiteList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            var list = guideCarModule.GetGuideCarSiteList(query);
            var result = list.Where(x => x.IsEnable == 1).Select(x => new { x.ID, x.SiteName });
            return ApiResult.Success("", result);
        }


        /// <summary>
        /// 保存司导站点信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCarSite()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            if (query == null)
            {
                return ApiResult.Failed("请传入站点信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.SiteName))
                {
                    return ApiResult.Failed("请输入站点名称");
                }

                if (query.RegionList == null || !query.RegionList.Any())
                {
                    return ApiResult.Failed("请选择地区");
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCarSite(query);
                if (result)
                {
                    return ApiResult.Success("站点信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("站点信息保存失败");
                }
            }
        }


        #endregion

        #region 导游信息
        [HttpPost]
        public ApiResult GetGuidePageListRepository()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_Guide_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuidePageListRepository(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.GuidePhoto,
                x.Name,
                x.WorkYears,
                Score = x.Score == 0 ? "暂无" : x.Score.ToString(),
                x.SiteName,
                x.OrderNum,
                x.GoodsList,
                x.GoodsNum,
                CreateDateStr = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                x.IsEnable,
                x.Telephone,
                x.EmergencyPhone

            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 禁用/启用导游状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult EnableGuideCarGuideInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            string idInfo = parmsJob.GetStringValue("Ids");
            int isEnable = parmsJob.GetInt("IsEnable", 0);
            if (string.IsNullOrWhiteSpace(idInfo))
            {
                return ApiResult.Failed("请传递参数");
            }

            bool flag = guideCarModule.EnableGuideCarGuideInfo(idInfo.Split(",").ToList(), isEnable, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetGuideCarGuideModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarGuideModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Guide_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存司导导游信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCarGuide()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.IsEnable = 0;
            if (query == null)
            {
                return ApiResult.Failed("请传入站点信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入导游名称");
                }
                if (string.IsNullOrWhiteSpace(query.GuidePhoto))
                {
                    return ApiResult.Failed("请上传导游头像");
                }
                if (string.IsNullOrWhiteSpace(query.Telephone))
                {
                    return ApiResult.Failed("请输入联系电话");
                }
                if (string.IsNullOrWhiteSpace(query.EmergencyPhone))
                {
                    return ApiResult.Failed("请输入紧急联系电话");
                }
                if (query.SiteId == 0)
                {
                    return ApiResult.Failed("请选择站点信息");
                }
                if (string.IsNullOrWhiteSpace(query.Introduction))
                {
                    return ApiResult.Failed("请输入间接");
                }

                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCarGuide(query);
                if (result)
                {
                    return ApiResult.Success("导游信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("导游信息保存失败");
                }
            }
        }
        #endregion
    }
}