﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;

namespace Mall.Common.Pay.Alipay
{
    /// <summary>
    /// 支付宝帮助类
    /// </summary>
    public class AlipayHelp
    {
        /// <summary>
        /// 创建支付宝url
        /// </summary>
        /// <param name="sOrderNo">订单编号</param>
        /// <param name="sOrderName">订单名称</param>
        /// <param name="sMoney">金额</param>
        /// <param name="sOrderDescription">订单描述</param>
        /// <param name="sNotifyUrl">服务器异步通知页面路径</param>
        /// <param name="sReturnUrl">页面跳转同步通知页面路径</param>
        /// <param name="bIsFormSubmit"></param>
        /// <returns></returns>
        public static string CreateAlipayUrl(string sOrderNo, string sOrderName, string sMoney,
            string sOrderDescription, string sNotifyUrl, string sReturnUrl, bool bIsFormSubmit = true)
        {
            #region 创建支付宝url
            string GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
            string payment_type = "1";
            //必填，不能修改
            //服务器异步通知页面路径
            string notify_url = "http://" + HttpContext.Current.Request.Url.Authority + sNotifyUrl;
            //需http://格式的完整路径，不能加?id=123这类自定义参数

            //页面跳转同步通知页面路径
            string return_url = "http://" + HttpContext.Current.Request.Url.Authority + sReturnUrl;
            //需http://格式的完整路径，不能加?id=123这类自定义参数，不能写成http://localhost/

            //卖家支付宝帐户
            string seller_email = Common.Config.GetAppSetting("AlipayName"); //"AlipayName".ReadConfig();
            //必填

            //商户订单号
            string out_trade_no = sOrderNo;
            //商户网站订单系统中唯一订单号，必填

            //订单名称
            string subject = sOrderName;
            //必填

            //付款金额
            string total_fee = sMoney;
            //必填

            //订单描述

            string body = sOrderDescription;
            //商品展示地址
            string show_url = "";
            //需以http://开头的完整路径，例如：http://www.xxx.com/myorder.html

            //防钓鱼时间戳
            string anti_phishing_key = "";
            //若要使用请调用类文件submit中的query_timestamp函数

            //客户端的IP地址
            string exter_invoke_ip = "";//Function.NetIP();
            //非局域网的外网IP地址，如：221.0.0.1


            ////////////////////////////////////////////////////////////////////////////////////////////////

            //把请求参数打包成数组
            SortedDictionary<string, string> sParaTemp = new SortedDictionary<string, string>
            {
                { "partner", Config.Partner },
                { "_input_charset", Config.Input_charset.ToLower() },
                { "service", "create_direct_pay_by_user" },
                { "payment_type", payment_type },
                { "notify_url", notify_url },
                { "return_url", return_url },
                { "seller_email", seller_email },
                { "out_trade_no", out_trade_no },
                { "subject", subject },
                { "total_fee", total_fee },
                { "body", body },
                { "show_url", show_url },
                { "anti_phishing_key", anti_phishing_key },
                { "exter_invoke_ip", exter_invoke_ip }
            };

            //建立请求
            string sHtmlText = string.Empty;
            if (bIsFormSubmit)
                sHtmlText = Submit.BuildRequest(GATEWAY_NEW, sParaTemp, "Get", "提交");
            else
                sHtmlText = Submit.BuildUrl(GATEWAY_NEW, sParaTemp);
            return sHtmlText;
            #endregion
        }

        /// <summary>
        /// 支付宝app支付
        /// </summary>
        /// <param name="sOrderNo">订单编号</param>
        /// <param name="sProductName">产品名称</param>
        /// <param name="dPrice">价格</param>
        /// <param name="CustomerId">客户编号</param>
        /// <returns></returns>
        public static string AppPayRequest(string sOrderNo, string sProductName, decimal dPrice, string CustomerId)
        {
            string orderInfo = string.Empty;
            //  string FilialeIdStr = Common.Config.GetAppSetting("FilialeId");//分公司总经理岗位id
            // 签约合作者身份ID
            //orderInfo = "partner=" + "\"" + "AlipayID".ReadConfig() + "\"";
            orderInfo = "partner=" + "\"" + Common.Config.GetAppSetting("AlipayID") + "\"";
            // 签约卖家支付宝账号
            //orderInfo += "&seller_id=" + "\"" + "AlipayName".ReadConfig() + "\"";
            orderInfo += "&seller_id=" + "\"" + Common.Config.GetAppSetting("AlipayName") + "\"";
            // 商户网站唯一订单号
            orderInfo += "&out_trade_no=" + "\"" + sOrderNo + "\"";
            // 商品名称
            orderInfo += "&subject=\"" + "支付订单" + "\"";
            // 商品详情
            orderInfo += "&body=" + "\"" + sProductName + "\"";
            // 商品金额
            orderInfo += "&total_fee=" + "\"" + dPrice + "\"";
            // 服务器异步通知页面路径
            //orderInfo += "&notify_url=" + "\"" + "AlipayPayNotifyUrl".ReadConfig() + "\"";
            orderInfo += "&notify_url=" + "\"" + Common.Config.GetAppSetting("AlipayPayNotifyUrl") + "\"";
            // 服务接口名称， 固定值
            orderInfo += "&service=\"mobile.securitypay.pay\"";
            // 支付类型， 固定值
            orderInfo += "&payment_type=\"1\"";
            // 参数编码， 固定值
            orderInfo += "&_input_charset=\"utf-8\"";
            // 设置未付款交易的超时时间
            // 默认30分钟，一旦超时，该笔交易就会自动被关闭。
            // 取值范围：1m～15d。
            // m-分钟，h-小时，d-天，1c-当天（无论交易何时创建，都在0点关闭）。
            // 该参数数值不接受小数点，如1.5h，可转换为90m。
            orderInfo += "&it_b_pay=\"30m\"";
            // extern_token为经过快登授权获取到的alipay_open_id,带上此参数用户将使用授权的账户进行支付
            // orderInfo += "&extern_token=" + "\"" + extern_token + "\"";
            // 支付宝处理完请求后，当前页面跳转到商户指定页面的路径，可空
            orderInfo += "&return_url=\"m.alipay.com\"";
            // 调用银行卡支付，需配置此参数，参与签名， 固定值 （需要签约《无线银行卡快捷支付》才能使用）
            // orderInfo += "&paymethod=\"expressGateway\"";
            //  return  "{ \"sOrderInfo\":\"" + HttpUtility.UrlEncode(orderInfo) + "\",\"AlipayPrivateKey\":\"" + "AlipayPrivateKey".ReadConfig() + "\"}";
            return "{ \"sOrderInfo\":\"" + HttpUtility.UrlEncode(orderInfo) + "\",\"AlipayPrivateKey\":\"" + Common.Config.GetAppSetting("AlipayPrivateKey") + "\"}";
        }

        /// <summary>
        /// 获取支付宝POST过来通知消息，并以“参数名=参数值”的形式组成数组
        /// </summary>
        /// <returns>request回来的信息组成的数组</returns>
        public static SortedDictionary<string, string> GetRequestPost()
        {
            #region 获取支付宝POST过来通知消息，并以“参数名=参数值”的形式组成数组
            int i = 0;
            SortedDictionary<string, string> sArray = new SortedDictionary<string, string>();
            NameValueCollection coll;
            //Load Form variables into NameValueCollection variable.
            coll = HttpContext.Current.Request.Form;

            // Get names of all forms into a string array.
            String[] requestItem = coll.AllKeys;

            for (i = 0; i < requestItem.Length; i++)
            {
                sArray.Add(requestItem[i], HttpContext.Current.Request.Form[requestItem[i]]);
            }

            return sArray;
            #endregion
        }

        /// <summary>
        /// 获取支付宝GET过来通知消息，并以“参数名=参数值”的形式组成数组
        /// </summary>
        /// <returns>request回来的信息组成的数组</returns>
        public static SortedDictionary<string, string> GetRequestGet()
        {
            #region 获取支付宝GET过来通知消息，并以“参数名=参数值”的形式组成数组
            int i = 0;
            SortedDictionary<string, string> sArray = new SortedDictionary<string, string>();
            NameValueCollection coll;
            //Load Form variables into NameValueCollection variable.
            coll = HttpContext.Current.Request.QueryString;

            // Get names of all forms into a string array.
            String[] requestItem = coll.AllKeys;

            for (i = 0; i < requestItem.Length; i++)
            {
                sArray.Add(requestItem[i], HttpContext.Current.Request.QueryString[requestItem[i]]);
            }

            return sArray;
            #endregion
        }
    }
}