﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Mall.Common.Enum;
using VT.FW.DB.Dapper;

namespace Mall.Repository.User
{
    /// <summary>
    /// 小程序管理员仓储层
    /// </summary>
    public class RB_Miniprogram_AdminRepository:BaseRepository<RB_Miniprogram_Admin>
    {
        /// <summary>
        /// 获取管理员分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Miniprogram_Admin_Extend> GetMiniprogramAdminPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Miniprogram_Admin_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Photo,B.Moblie,B.`Name`,B.OpenId,B.Source
FROM rb_miniprogram_admin AS A LEFT JOIN rb_member_user AS B ON A.UserId=B.Id
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat($@" and B.{nameof(RB_Miniprogram_Admin_Extend.Name)} like @Name ");
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (query.Source > 0)
                {
                    builder.AppendFormat(" AND B.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.Source), (int)query.Source);
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Miniprogram_Admin_Extend.AdminId));
            return GetPage<RB_Miniprogram_Admin_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取管理员实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Miniprogram_Admin_Extend GetMiniprogramAdminEntityRepository( RB_Miniprogram_Admin_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.Photo,B.Moblie,B.`Name`,B.OpenId,B.Source
FROM rb_miniprogram_admin AS A LEFT JOIN rb_member_user AS B ON A.UserId=B.Id
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat($@" and B.{nameof(RB_Miniprogram_Admin_Extend.Name)} like @Name ");
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (query.Source > 0)
                {
                    builder.AppendFormat(" AND B.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.Source), (int)query.Source);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Miniprogram_Admin_Extend.UserId), query.UserId);
                }
            }
            return Get<RB_Miniprogram_Admin_Extend>(builder.ToString(), parameters)?.FirstOrDefault();
        }
    }
}
