﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单售后仓储层
    /// </summary>
    public class RB_Goods_OrderAfterSaleRepository : RepositoryBase<RB_Goods_OrderAfterSale>
    {

        /// <summary>
        /// 获取售后订单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderAfterSale_Extend> GetERPPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderAfterSale_Extend dmodel) {
            string where = $" where 1=1 and oas.{nameof(RB_Goods_OrderAfterSale.Status)}=0";

            if (dmodel.TenantId > 0) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName)) {
                where += $" and mu.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }
            if (dmodel.OrderId > 0) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.OrderId)}={dmodel.OrderId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ReOrderNo)) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderNo)} like '%{dmodel.ReOrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo)) {
                where += $" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }
            if (dmodel.OrderSource > 0) {
                where += $" and o.{nameof(RB_Goods_Order.OrderSource)} ={dmodel.OrderSource}";
            }
            if (!string.IsNullOrEmpty(dmodel.Consignee))
            {
                where += $" and o.{nameof(RB_Goods_Order.Consignee)} like '%{dmodel.Consignee}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $" and o.{nameof(RB_Goods_Order.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName)) {
                where += $" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (dmodel.SelectStatus == 1)//待审核
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderStatus)}=1";
            }
            else if (dmodel.SelectStatus == 2)//待买家处理
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderStatus)}=2";
            }
            else if (dmodel.SelectStatus == 3) {//待卖家处理
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderStatus)} in(3,4)";
            }
            else if (dmodel.SelectStatus == 4)//已完成
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderStatus)} in(5,6)";
            }

            string sql = $@"SELECT oas.*,mu.Name as UserName FROM rb_goods_orderaftersale oas
INNER JOIN rb_goods_order o on oas.OrderId=o.OrderId
INNER JOIN rb_goods_orderdetail od on od.Id=oas.OrderDetialId
INNER JOIN rb_member_user mu on mu.Id=oas.UserId
{where} order by oas.ReOrderId desc";
            return GetPage<RB_Goods_OrderAfterSale_Extend>(pageIndex, pageSize, out count, sql).ToList();

        }

        /// <summary>
        /// 获取售后订单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderAfterSale_Extend> GetAppletPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderAfterSale_Extend dmodel)
        {
            string where = $" where 1=1 and oas.{nameof(RB_Goods_OrderAfterSale.Status)}=0";

            if (dmodel.TenantId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.UserId)}={dmodel.UserId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.ReOrderStatus > 0) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderStatus)}={(int)dmodel.ReOrderStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.ReOrderNo))
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderNo)} like '%{dmodel.ReOrderNo}%'";
            }

            string sql = $@"SELECT oas.* FROM rb_goods_orderaftersale oas {where} order by ReOrderId desc";
            return GetPage<RB_Goods_OrderAfterSale_Extend>(pageIndex, pageSize, out count, sql).ToList();

        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderAfterSale_Extend> GetList(RB_Goods_OrderAfterSale_Extend dmodel) {
            string where = $" where 1=1 and oas.{nameof(RB_Goods_OrderAfterSale.Status)}=0";

            if (dmodel.TenantId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.UserId)}={dmodel.UserId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderDetialId > 0)
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.OrderDetialId)}={dmodel.OrderDetialId}";
            }
            if (dmodel.Type > 0) 
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.Type)}={dmodel.Type}";
            }
            if (!string.IsNullOrEmpty(dmodel.ReOrderNo))
            {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.ReOrderNo)} like '%{dmodel.ReOrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderDetailIds)) {
                where += $" and oas.{nameof(RB_Goods_OrderAfterSale.OrderDetialId)} in({dmodel.OrderDetailIds})";
            }

            string sql = $@"SELECT oas.* FROM rb_goods_orderaftersale oas {where} order by oas.ReOrderId desc";
            return Get<RB_Goods_OrderAfterSale_Extend>(sql).ToList();
        }
    }
}
