﻿using System;
using System.Linq;
using Mall.AOP;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Module.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Reserve
{
    /// <summary>
    /// 小程序门店商品
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletStoresController : BaseController
    {
        /// <summary>
        /// 门店处理类对象
        /// </summary>
        private readonly ContentModule contentModule = AOPHelper.CreateAOPObject<ContentModule>();

        /// <summary>
        /// 线下服务商品处理类对象
        /// </summary>
        private readonly OfflineGoodsModule offlineGoodsModule = AOPHelper.CreateAOPObject<OfflineGoodsModule>();

        /// <summary>
        /// 线下服务首页获取当前距离最近门店
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public virtual ApiResult GetCurrentStore(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            JObject parm = JObject.Parse(parms.msg.ToString());
            var position = parm.GetStringValue("position");
            int storeId = parm.GetInt("storeId");
            var storeModel = contentModule.GetStoresListModule(new RB_Stores_Extend()
            {
                CurrentPosition = position,
                Id = storeId,
                MallBaseId = parms.MallBaseId
            }, isFirst: true)?.FirstOrDefault();
            object result = new
            {
                storeInfo = new
                {
                    storeId = storeModel?.Id,
                    storeName = storeModel?.Name,
                    storeAddress = storeModel?.Address,
                    storeTel = storeModel?.Tel,
                    distance = storeModel?.KM,
                    storeCoverImg = storeModel?.CoverImg,
                    storeNavImg = storeModel?.NavImg
                },
            };
            return ApiResult.Success(data: result);
        }


        /// <summary>
        /// 小程序获取门店分页列表
        /// </summary>
        /// <param name="requestMsg"></param>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public virtual ApiResult GetStorePage(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(parms.msg.ToString());
            query.TenantId = parms.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = contentModule.GetStoresPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.pageData = list;
            pageModel.count = Convert.ToInt32(rowsCount);
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取门店详情
        /// </summary>
        /// <param name="requestMsg"></param>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public virtual ApiResult GetStoreInfo(object requestMsg)
        {
            var parms = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            if (parms.MallBaseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            JObject parm = JObject.Parse(parms.msg.ToString());
            int storeId = parm.GetInt("storeId");
            var position = parm.GetStringValue("position");
            var storeModel = contentModule.GetStoresListModule(new RB_Stores_Extend()
            {
                Id = storeId,
                MallBaseId = parms.MallBaseId
            }, isFirst: true)?.FirstOrDefault();
            object result = new
            {
                storeInfo = new
                {
                    storeId = storeModel?.Id,
                    storeName = storeModel?.Name,
                    storeAddress = storeModel?.Address,
                    storeTel = storeModel?.Tel,
                    distance = storeModel?.KM,
                    storeScore=storeModel?.Score,
                    storeCoverImg = storeModel?.CoverImg,
                    storeNavImg = storeModel?.NavImg
                },
            };
            return ApiResult.Success(data: result);
        }
    }
}
