﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Web;
using System.Xml.Serialization;
using Newtonsoft.Json;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 公共帮助类
    /// </summary>
    public class CommonHelper
    {
        /// <summary>
        /// 获取oss文件全路径地址
        /// </summary>
        /// <param name="fileList"></param>
        /// <returns></returns>
        public static List<string> GetOssFileFullPath(List<string> fileList)
        {
            List<string> resultFileList = new List<string>();
            foreach (var item in fileList)
            {
                resultFileList.Add(Config.GetFileUrl(item));
            }
            return resultFileList;
        }

        /// <summary>
        /// 取得用户客户端IP(穿过代理服务器取远程用户真实IP地址)
        /// </summary>
        //public static string GetClientIP()
        //{
        //    try
        //    {
        //        if (HttpContext.Current.Request.ServerVariables["HTTP_VIA"] != null)
        //        {
        //            return HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"].ToString();
        //        }
        //        else
        //        {
        //            return HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"].ToString();
        //        }
        //    }
        //    catch
        //    {
        //        return "0.0.0.0";
        //    }
        //}

        /// <summary>
        /// 获取当前域名
        /// </summary>
        /// <returns></returns>
        //public static string GetDomain()
        //{
        //    try
        //    {
        //        string Domain =  HttpContext.Current.Request.Url.Host;
        //        if (Domain == null || string.IsNullOrEmpty(Domain))
        //        {
        //            return "";
        //        }
        //        else
        //        {
        //            return Domain;
        //        }
        //    }
        //    catch
        //    {
        //        return "";
        //    }
        //}

        /// <summary>
        /// 根据出生日期判断人的类型
        /// </summary>
        /// <param name="birthDate">出生日期</param>
        /// <returns></returns>
        public static string CalculateAgeCorrect(DateTime birthDate)
        {
            DateTime now = DateTime.Now;
            int age = now.Year - birthDate.Year;
            if (now.Month < birthDate.Month || (now.Month == birthDate.Month && now.Day < birthDate.Day)) age--;
            if (age < 2)
            {
                return "婴儿";
            }
            else if (2 <= age && age < 12)
            {
                return "小孩";
            }
            else
            {
                return "成人";
            }
        }

        /// <summary>
        /// 根据出生日期判断人的类型
        /// </summary>
        /// <param name="birthDate">出生日期</param>
        /// <returns></returns>
        public static int GetAgeCorrect(DateTime birthDate)
        {
            DateTime now = DateTime.Now;
            int age = now.Year - birthDate.Year;
            if (now.Month < birthDate.Month || (now.Month == birthDate.Month && now.Day < birthDate.Day))
            {
                age--;
            }
            if (age <= 11)
            {
                return 3;
            }
            else if (12 <= age && age < 18)
            {
                return 2;
            }
            else
            {
                return 1;
            }
        }

        /// <summary>
        /// 根据功能编码获取用户是否拥有该权限
        /// </summary>
        /// <param name="ActionCode"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public static bool GetUserActionPermission(string ActionCode, UserInfo userInfo)
        {
            if (!string.IsNullOrEmpty(userInfo.ActionMenuCode) && ("," + userInfo.ActionMenuCode + ",").Contains("," + ActionCode + ","))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// 根据URL地址获取文件路径
        /// </summary>
        /// <param name="url">文件路劲</param>
        /// <returns></returns>
        public static string GetFilePath(string url)
        {
            string path = string.Empty;
            try
            {
                Uri uri = new Uri(url);
                path = uri.AbsolutePath;
            }
            catch
            {

            }
            return path;
        }

        /// <summary>
        /// 根据日期获取星期几
        /// </summary>
        /// <param name="date">日期</param>
        /// <returns></returns>
        public static int GetWeekNow(DateTime date)
        {
            string strWeek = date.DayOfWeek.ToString();
            int weekDay = 0;
            switch (strWeek)
            {
                case "Monday": weekDay = 1; break;
                case "Tuesday": weekDay = 2; break;
                case "Wednesday": weekDay = 3; break;
                case "Thursday": weekDay = 4; break;
                case "Friday": weekDay = 5; break;
                case "Saturday": weekDay = 6; break;
                case "Sunday": weekDay = 7; break;
            }
            return weekDay;
        }

        /// <summary>
        /// 根据日期获取星期几
        /// </summary>
        /// <param name="date">日期</param>
        /// <returns></returns>
        public static string GetWeekDay(DateTime date)
        {
            string strWeek = date.DayOfWeek.ToString();
            string  weekDay ="";
            switch (strWeek)
            {
                case "Monday": weekDay = "一"; break;
                case "Tuesday": weekDay = "二"; break;
                case "Wednesday": weekDay = "三"; break;
                case "Thursday": weekDay = "四"; break;
                case "Friday": weekDay = "五"; break;
                case "Saturday": weekDay = "六"; break;
                case "Sunday": weekDay = "日"; break;
            }
            return weekDay;
        }

        /// <summary>
        /// 判断是否为时间格式
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool IsTime(string value)
        {
            bool flag = true;
            try
            {
                Convert.ToDateTime("2019-01-01 " + value.Trim());
            }
            catch (Exception)
            {
                flag = false;
            }
            return flag;
        }

        /// <summary>
        /// 时间格式化(dd+英文月+YY)
        /// </summary>
        /// <returns></returns>
        public static string DateTimeFormat(DateTime dt)
        {
            string str = string.Empty;
            try
            {
                int month = dt.Month;
                switch (month)
                {
                    case 1: str = dt.ToString("dd") + "Jan" + dt.Year.ToString().Substring(2); break;
                    case 2: str = dt.ToString("dd") + "Feb" + dt.Year.ToString().Substring(2); break;
                    case 3: str = dt.ToString("dd") + "Mar" + dt.Year.ToString().Substring(2); break;
                    case 4: str = dt.ToString("dd") + "Apr" + dt.Year.ToString().Substring(2); break;
                    case 5: str = dt.ToString("dd") + "May" + dt.Year.ToString().Substring(2); break;
                    case 6: str = dt.ToString("dd") + "Jun" + dt.Year.ToString().Substring(2); break;
                    case 7: str = dt.ToString("dd") + "Jul" + dt.Year.ToString().Substring(2); break;
                    case 8: str = dt.ToString("dd") + "Aug" + dt.Year.ToString().Substring(2); break;
                    case 9: str = dt.ToString("dd") + "Sept" + dt.Year.ToString().Substring(2); break;
                    case 10: str = dt.ToString("dd") + "Oct" + dt.Year.ToString().Substring(2); break;
                    case 11: str = dt.ToString("dd") + "Nov" + dt.Year.ToString().Substring(2); break;
                    case 12: str = dt.ToString("dd") + "Dec" + dt.Year.ToString().Substring(2); break;
                }
            }
            catch
            {

            }
            return str;
        }

        /// <summary>
        /// 克隆对象
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static T Clone<T>(T obj)
        {
            T ret = default(T);
            if (obj != null)
            {
                XmlSerializer cloner = new XmlSerializer(typeof(T));
                MemoryStream stream = new MemoryStream();
                cloner.Serialize(stream, obj);
                stream.Seek(0, SeekOrigin.Begin);
                ret = (T)cloner.Deserialize(stream);
            }
            return ret;
        }
    }
}
