﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Miai;
using Mall.Model.Extend.Assess;
using Mall.Model.Extend.Assess;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AssessController : BaseController
    {
        private readonly AssessModule assessModule = new AssessModule();

        #region 分类
        /// <summary>
        /// 获取分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCategoryPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Assess_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            var list = assessModule.GetCategoryPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Image,
                x.Enable,
                x.Sort,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取分类下拉列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCategoryDropList()
        {
            var req = base.RequestParm;
            RB_Assess_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.Enable = 1;
            var list = assessModule.GetCategoryList(demodel);
            return ApiResult.Success("", list.OrderByDescending(x => x.Sort).Select(x => new
            {
                x.Id,
                x.Name,
                x.Image,
                x.Sort,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            }));
        }

        /// <summary>
        /// 新增修改分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCategoryInfo()
        {
            var req = RequestParm;
            RB_Assess_Category_Extend demodel = JsonHelper.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请传递分类名称");
            }
            if (string.IsNullOrEmpty(demodel.Image))
            {
                return ApiResult.ParamIsNull("请上传分类背景图片");
            }
            demodel.Enable = demodel.Enable == 0 ? 1 : demodel.Enable;

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.CreateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateBy = req.EmpId;

            string msg = assessModule.SetCategoryInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 删除分类
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelCategoryInfo()
        {
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int CategoryId = parms.GetInt("CategoryId", 0);
            if (CategoryId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = assessModule.DelCategoryInfo(CategoryId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 品牌

        /// <summary>
        /// 获取品牌分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBrandPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            JObject jobj = JObject.Parse(req.msg.ToString());
            RB_Assess_Brand_Extend demodel = new RB_Assess_Brand_Extend()
            {
                CategoryId = jobj.GetInt("CategoryId"),
                Name = jobj.GetStringValue("Name")
            };
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            var list = assessModule.GetBrandPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Logo,
                x.IsHot,
                x.BrandImgList,
                x.MoreDesc,
                x.RemarkDesc,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                x.CategoryName,
                x.CategoryId,
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取品牌详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBrandInfo()
        {
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int BrandId = parms.GetInt("BrandId", 0);
            if (BrandId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = assessModule.GetBrandInfo(BrandId);
            if (model == null) { return ApiResult.Failed(); }

            return ApiResult.Success("", new
            {
                model.Id,
                model.CategoryId,
                model.Name,
                model.Logo,
                model.IsHot,
                model.BrandImgList,
                model.MoreDesc,
                model.RemarkDesc
            });
        }

        /// <summary>
        /// 新增修改品牌
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBrandInfo()
        {
            var req = RequestParm;
            RB_Assess_Brand_Extend demodel = JsonHelper.DeserializeObject<RB_Assess_Brand_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请传递品牌名称");
            }
            if (demodel.CategoryId <= 0)
            {
                return ApiResult.ParamIsNull("请传递分类ID");
            }
            if (string.IsNullOrEmpty(demodel.Logo))
            {
                return ApiResult.ParamIsNull("请上传品牌Logo图标");
            }
            if (demodel.BrandImgList == null || !demodel.BrandImgList.Any())
            {
                return ApiResult.ParamIsNull("请上传组图");
            }
            int Sort = 1;
            foreach (var item in demodel.BrandImgList)
            {
                item.Sort = Sort;
                if (string.IsNullOrEmpty(item.Name))
                {
                    return ApiResult.ParamIsNull("请上传组图标题");
                }
                if (string.IsNullOrEmpty(item.Path))
                {
                    return ApiResult.ParamIsNull("请传递组图路径");
                }
                Sort++;
            }
            demodel.BrandImg = JsonHelper.Serialize(demodel.BrandImgList);
            if (string.IsNullOrEmpty(demodel.MoreDesc))
            {
                return ApiResult.ParamIsNull("请输入更多描述");
            }
            if (string.IsNullOrEmpty(demodel.RemarkDesc))
            {
                return ApiResult.ParamIsNull("请输入备注描述");
            }

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.CreateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateBy = req.EmpId;

            string msg = assessModule.SetBrandInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 删除品牌
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelBrandInfo()
        {
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int BrandId = parms.GetInt("BrandId", 0);
            if (BrandId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = assessModule.DelBrandInfo(BrandId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 估价回复

        /// <summary>
        /// 获取估价分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoodsPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Assess_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Goods_Extend>(req.msg.ToString());

            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            var list = assessModule.GetGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                x.UserName,
                x.CategoryId,
                x.CategoryName,
                x.BrandId,
                x.BrandName,
                x.GoodsImgList,
                x.MoreImgList,
                x.Remark,
                x.ReplyContent,
                ReplyDate = x.ReplyDate.HasValue ? x.ReplyDate.Value.ToString("yyyy-MM-dd") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 回复消息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGoodsReply()
        {
            var req = base.RequestParm;
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int GoodsId = parms.GetInt("GoodsId", 0);
            string ReplyContent = parms.GetStringValue("ReplyContent");
            if (GoodsId <= 0)
            {
                return ApiResult.ParamIsNull("请传递商品估价ID");
            }
            if (string.IsNullOrEmpty(ReplyContent))
            {
                return ApiResult.ParamIsNull("请传递回复内容");
            }

            bool flag = assessModule.SetGoodsReply(GoodsId, ReplyContent, base.UserInfo);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion
    }
}