﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MiAi;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 相亲消息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_Message
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 来源id
        /// </summary>        
        public int SourceId
        {
            get;
            set;
        }
        /// <summary>
        /// 接收用户id
        /// </summary>        
        public int UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  枚举
        /// </summary>        
        public MessageTypeEnum Type
        {
            get;
            set;
        }
        /// <summary>
        /// 操作内容
        /// </summary>        
        public string Content
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime UpdateDate
        {
            get;
            set;
        }
    }
}
