﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 奖项实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Prize
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int Id { get; set; }

        ///// <summary>
        ///// 类型  1载体  2品牌
        ///// </summary>
        //public int Type { get; set; }


        /// <summary>
        /// 年份
        /// </summary>
        public int YearInfo { get; set; }
        /// <summary>
        /// 奖项名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 大奖章
        /// </summary>
        public string BigIco { get; set; }

        /// <summary>
        /// 小奖章
        /// </summary>
        public string SmallIco { get; set; }

      

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }
    }
}
