﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// Fat咨询处理类
    /// </summary>
    public class CommerceAskModule
    {
        /// <summary>
        /// Fat咨询仓储层对象
        /// </summary>
        private readonly RB_Commerce_AskRepository askRepository = new RB_Commerce_AskRepository();

        /// <summary>
        /// 获取FAT咨询分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Ask_Extend> GetCommerceAskPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Ask_Extend query)
        {
            return askRepository.GetCommerceAskPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改Fat咨询
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceAskModule(RB_Commerce_Ask_Extend model)
        {
            bool flag = false;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Commerce_Ask_Extend.CompanyName),model.CompanyName },
                    {nameof(RB_Commerce_Ask_Extend.Principal),model.Principal },
                    {nameof(RB_Commerce_Ask_Extend.Mobile),model.Mobile },
                    {nameof(RB_Commerce_Ask_Extend.EMail),model.EMail },
                    {nameof(RB_Commerce_Ask_Extend.FatCode),model.FatCode },
                    {nameof(RB_Commerce_Ask_Extend.FatTitle),model.FatTitle },
                    {nameof(RB_Commerce_Ask_Extend.FatQuestion),model.FatQuestion },
                    {nameof(RB_Commerce_Ask_Extend.FatContent),model.FatContent },
                };
                flag = askRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Ask_Extend.Id),model.Id));
            }
            else
            {
                var newId = askRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取Fat咨询详情
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Commerce_Ask_Extend GetCommerceAskModule(object Id)
        {
            return askRepository.GetEntity<RB_Commerce_Ask_Extend>(Id);
        }

        /// <summary>
        /// 更新咨询状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCommerceAskModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_Ask_Extend.Status),Status },
            };
            bool flag = askRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Ask_Extend.Id), Id));
            return flag;
        }
    }
}