﻿using Mall.Common.Enum.User;

namespace Mall.Common
{
    /// <summary>
    /// 小程序用户信息缓存
    /// </summary>
    public class AppletUserInfo
    {
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }



        /// <summary>
        /// 教育学生id
        /// </summary>
        public int EduStudentId { get; set; }
        /// 用户店铺id
        /// </summary>
        public int SmallShopId { get; set; }
        /// 用户对应的老师id
        /// </summary>
        public int UserTeacher { get; set; }


        /// <summary>
        /// 用户所属店铺id
        /// </summary>
        public int UserSmallShopId { get; set; }

        /// <summary>
        /// 唯一码
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }

        /// <summary>
        /// 
        /// 
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 手机号码
        /// </summary>        
        public string Mobile
        {
            get;
            set;
        }

        /// <summary>
        /// 上级id
        /// </summary>
        public int SuperiorId { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 来源  1微信  2支付宝
        /// </summary>        
        public UserSourceEnum? Source
        {
            get;
            set;
        }

        /// <summary>
        /// 商城名称
        /// </summary>        
        public string MallName
        {
            get;
            set;
        }

        /// <summary>
        /// token
        /// </summary>
        public string Token { get; set; }

        /// <summary>
        /// SecretKey
        /// </summary>
        public string SecretKey { get; set; }

        /// <summary>
        /// 是否加入了黑名单  1是
        /// </summary>
        public int? Blacklist { get; set; }

        /// <summary>
        /// 类型
        /// </summary>
        public Common.Enum.Goods.GoodsPageTypeEnum? UserPageType { get; set; }


        /// <summary>
        /// 是否开启校园版(1-开启)
        /// </summary>
        public int IsOpenSchool { get; set; }

        /// <summary>
        /// 相亲项目-1已填写，0-未填写
        /// </summary>
        public int IsAddBaseInfo { get; set; }

        /// <summary>
        /// 普通会员等级
        /// </summary>
        public int MemberGradeId { get; set; }

        /// <summary>
        /// 相亲是否开启  0-未开启，1-开启
        /// </summary>
        public int IsOpenMiAi { get; set; }

        /// <summary>
        /// 是否管理员  1是
        /// </summary>
        public int IsAdmin { get; set; }

        /// <summary>
        /// 小程序管理员编号
        /// </summary>
        public int AdminId { get; set; }

        /// <summary>
        /// 后台Token
        /// </summary>
        public string AdminToken { get; set; }

        /// <summary>
        /// 用户所在群组
        /// </summary>
        public string UserGroupIds { get; set; }
    }
}