﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// 签名帮助类
    /// </summary>
    public class Sha1Util
    {
        /// <summary>
        /// 获取sha1签名
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static String GetSha1(String str)
        {
            //建立SHA1对象
            SHA1 sha = new SHA1CryptoServiceProvider();
            //将mystr转换成byte[] 
            var enc = new ASCIIEncoding();
            var dataToHash = enc.GetBytes(str);
            //Hash运算
            var dataHashed = sha.ComputeHash(dataToHash);
            //将运算结果转换成string
            var hash = BitConverter.ToString(dataHashed).Replace("-", "");
            return hash;
        }
    }
}
