﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单日志仓储层
    /// </summary>
    public class RB_Goods_LogRepository : BaseRepository<RB_Goods_Log>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Log_Extend> GetList(RB_Goods_Log_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Log.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Log.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Goods_Log.Type)}={dmodel.Type}";
            }
            if (dmodel.SourceId > 0)
            {
                where += $@" and {nameof(RB_Goods_Log.SourceId)}={dmodel.SourceId}";
            }            

            string sql = $@"SELECT * FROM RB_Goods_Log where {where} order by Id asc";
            return Get<RB_Goods_Log_Extend>(sql).ToList();
        }
    }
}
