﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 认证实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Authentication
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 首店名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }

        /// <summary>
        /// 图片 json格式
        /// </summary>
        public string Images { get; set; }

        /// <summary>
        /// 视频地址
        /// </summary>
        public string VideoUrl { get; set; }

        /// <summary>
        /// 类型  枚举
        /// </summary>
        public AuthenticationTypeEnum Type { get; set; }

        /// <summary>
        /// 品牌归属地  枚举
        /// </summary>
        public BrandTypeEnum BrandType { get; set; }

        /// <summary>
        /// 开业时间
        /// </summary>
        public DateTime OpenTime { get; set; }

        /// <summary>
        /// 地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 商圈
        /// </summary>
        public string TradingArea { get; set; }

        /// <summary>
        /// 行业 枚举
        /// </summary>
        public BusinessTypeEnum BusinessType { get; set; }

        /// <summary>
        /// 首店业种类型
        /// </summary>
        public string BusinessDetail { get; set; }

        /// <summary>
        /// 简介
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 所在区县
        /// </summary>
        public string County { get; set; }

        /// <summary>
        /// 类别  枚举
        /// </summary>
        public AuthenticationCategoryEnum Category { get; set; }

        /// <summary>
        /// 联系人
        /// </summary>
        public string Contact { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string ContactMobile { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 审核状态  1未审核   2审核通过   3审核不通过
        /// </summary>
        public int AuditState { get; set; }

        /// <summary>
        /// 审核备注
        /// </summary>
        public string AuditRemark { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditDate { get; set; }

    }
}
